/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.config;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.api.providers.IEntityTypeProvider;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedResourceLocationListValue;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class AdditionsConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedIntValue obsidianTNTDelay;
    public final CachedFloatValue obsidianTNTBlastRadius;
    public final CachedBooleanValue voiceServerEnabled;
    public final CachedIntValue voicePort;
    private final Map<BabyType, SpawnConfig> spawnConfigs = new EnumMap<BabyType, SpawnConfig>(BabyType.class);

    AdditionsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Additions Config. This config is synced between server and client.").push("additions");
        this.obsidianTNTDelay = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Fuse time for Obsidian TNT.").defineInRange("obsidianTNTDelay", 100, 0, Integer.MAX_VALUE));
        this.obsidianTNTBlastRadius = CachedFloatValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Radius of the explosion of Obsidian TNT.").defineInRange("obsidianTNTBlastRadius", 12.0, 0.1, 1000.0));
        this.voiceServerEnabled = CachedBooleanValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Enables the voice server for Walkie Talkies.").worldRestart().define("voiceServerEnabled", false));
        this.voicePort = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("TCP port for the Voice server to listen on.").defineInRange("VoicePort", 36123, 1, 65535));
        builder.comment("Config options regarding spawning of entities.").push("spawning");
        this.addBabyTypeConfig(BabyType.CREEPER, builder, (IEntityTypeProvider)AdditionsEntityTypes.BABY_CREEPER, () -> EntityType.f_20558_);
        this.addBabyTypeConfig(BabyType.ENDERMAN, builder, (IEntityTypeProvider)AdditionsEntityTypes.BABY_ENDERMAN, () -> EntityType.f_20566_);
        this.addBabyTypeConfig(BabyType.SKELETON, builder, (IEntityTypeProvider)AdditionsEntityTypes.BABY_SKELETON, () -> EntityType.f_20524_);
        this.addBabyTypeConfig(BabyType.STRAY, builder, (IEntityTypeProvider)AdditionsEntityTypes.BABY_STRAY, () -> EntityType.f_20481_);
        this.addBabyTypeConfig(BabyType.WITHER_SKELETON, builder, (IEntityTypeProvider)AdditionsEntityTypes.BABY_WITHER_SKELETON, () -> EntityType.f_20497_);
        builder.pop(2);
        this.configSpec = builder.build();
    }

    private void addBabyTypeConfig(BabyType type, ForgeConfigSpec.Builder builder, IEntityTypeProvider entityTypeProvider, IEntityTypeProvider parentTypeProvider) {
        this.spawnConfigs.put(type, new SpawnConfig((IMekanismConfig)this, builder, "baby " + type.m_7912_().replace('_', ' '), entityTypeProvider, parentTypeProvider));
    }

    public String getFileName() {
        return "additions";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public SpawnConfig getConfig(BabyType babyType) {
        return this.spawnConfigs.get((Object)babyType);
    }

    public static class SpawnConfig {
        public final CachedBooleanValue shouldSpawn;
        public final CachedDoubleValue weightPercentage;
        public final CachedDoubleValue minSizePercentage;
        public final CachedDoubleValue maxSizePercentage;
        public final CachedDoubleValue spawnCostPerEntityPercentage;
        public final CachedDoubleValue maxSpawnCostPercentage;
        public final CachedResourceLocationListValue biomeBlackList;
        public final CachedResourceLocationListValue structureBlackList;
        public final IEntityTypeProvider entityTypeProvider;
        public final IEntityTypeProvider parentTypeProvider;

        private SpawnConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, String name, IEntityTypeProvider entityTypeProvider, IEntityTypeProvider parentTypeProvider) {
            this.entityTypeProvider = entityTypeProvider;
            this.parentTypeProvider = parentTypeProvider;
            builder.comment("Config options regarding " + name + ".").push(name.replace(" ", "-"));
            this.shouldSpawn = CachedBooleanValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Enable the spawning of " + name + ". Think baby zombies.").worldRestart().define("shouldSpawn", true));
            this.weightPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for weight of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("weightPercentage", 0.5, 0.0, 100.0));
            this.minSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for minimum group size of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("minSizePercentage", 0.5, 0.0, 100.0));
            this.maxSizePercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for maximum group size of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("maxSizePercentage", 0.5, 0.0, 100.0));
            this.spawnCostPerEntityPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for spawn cost per entity of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("spawnCostPerEntityPercentage", 1.0, 0.0, 100.0));
            this.maxSpawnCostPercentage = CachedDoubleValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The multiplier for max spawn cost of " + name + " spawns, compared to the adult mob.").worldRestart().defineInRange("maxSpawnCostPercentage", 1.0, 0.0, 100.0));
            this.biomeBlackList = CachedResourceLocationListValue.define((IMekanismConfig)config, (ForgeConfigSpec.Builder)builder.comment("The list of biome ids that " + name + " will not spawn in even if the normal mob variant can spawn.").worldRestart(), (String)"biomeBlackList", arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0));
            this.structureBlackList = CachedResourceLocationListValue.define((IMekanismConfig)config, (ForgeConfigSpec.Builder)builder.comment("The list of structure ids that " + name + " will not spawn in even if the normal mob variant can spawn.").worldRestart(), (String)"structureBlackList", arg_0 -> ((Registry)BuiltInRegistries.f_256763_).m_7804_(arg_0));
            builder.pop();
        }

        public MobSpawnSettings.SpawnerData getSpawner(MobSpawnSettings.SpawnerData parentEntry) {
            int weight = (int)Math.ceil((double)parentEntry.m_142631_().m_146281_() * this.weightPercentage.get());
            int minSize = (int)Math.ceil((double)parentEntry.f_48405_ * this.minSizePercentage.get());
            int maxSize = (int)Math.ceil((double)parentEntry.f_48406_ * this.maxSizePercentage.get());
            return new MobSpawnSettings.SpawnerData(this.entityTypeProvider.getEntityType(), weight, minSize, Math.max(minSize, maxSize));
        }

        public List<MobSpawnSettings.SpawnerData> getSpawnersToAdd(List<MobSpawnSettings.SpawnerData> monsterSpawns) {
            EntityType parent = this.parentTypeProvider.getEntityType();
            return monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.f_48404_ == parent).map(this::getSpawner).toList();
        }
    }
}

