/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.utils;

import com.google.common.collect.Maps;
import dev.uncandango.alltheleaks.AllTheLeaks;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ReflectionHelper {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Map<Class<?>, MethodHandles.Lookup> PRIVATE_LOOKUP = Maps.newHashMap();

    static boolean setField(Object obj, Class<?> clazz, String fieldName, Object arg) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(obj, arg);
            return true;
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.warn("Failed to set value {} to object {} from method from class {}.", new Object[]{arg, obj, clazz});
            return false;
        }
    }

    public static <T> List<T> getValueFromFieldWithClass(Object obj, Class<?> clazz, Class<T> fieldClazz) {
        ArrayList result = new ArrayList();
        Arrays.stream(clazz.getDeclaredFields()).filter(f -> fieldClazz.isAssignableFrom(f.getType())).forEach(targetField -> {
            try {
                targetField.setAccessible(true);
                result.add(fieldClazz.cast(targetField.get(obj)));
            }
            catch (Exception e) {
                AllTheLeaks.LOGGER.warn("Failed to get value from field {} with class {} from object {} with class {}.", new Object[]{targetField, fieldClazz, obj, clazz});
            }
        });
        return result;
    }

    static List<Field> getFieldsFromFieldWithClass(Class<?> clazz, Class<?> ... fieldClazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        Arrays.stream(clazz.getDeclaredFields()).filter(f -> Arrays.stream(fieldClazz).anyMatch(f1 -> f1.isAssignableFrom(f.getType()))).forEach(result::add);
        return result;
    }

    @Nullable
    static VarHandle getVarHandler(MethodHandles.Lookup lookup, Class<?> objClass, String name, Class<?> fieldClass) {
        VarHandle handler = null;
        try {
            handler = lookup.findVarHandle(objClass, name, fieldClass);
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.info("Failed to get varhandler.", (Throwable)e);
        }
        return handler;
    }

    static boolean setFieldWithCheck(Object obj, Class<?> clazz, String fieldName, Object arg) {
        if (clazz.isAssignableFrom(obj.getClass())) {
            return ReflectionHelper.setField(obj, clazz, fieldName, arg);
        }
        AllTheLeaks.LOGGER.debug("Object: {} is not of class {}", obj, clazz);
        return false;
    }

    static void setFields(Object obj, Class<?> clazz, Collection<String> fieldNames, Object[] args) {
        if (fieldNames.size() == args.length) {
            Iterator<String> it = fieldNames.iterator();
            int i = 0;
            while (it.hasNext()) {
                ReflectionHelper.setField(obj, clazz, it.next(), args[i]);
                ++i;
            }
        } else {
            AllTheLeaks.LOGGER.warn("Failed to set many fields on reflection, number of arrays does not match.");
        }
    }

    static void setFieldsToNull(Object obj, Class<?> clazz, Collection<String> fieldNames) {
        ReflectionHelper.setFields(obj, clazz, fieldNames, new Object[fieldNames.size()]);
    }

    static void nukeObject(Object obj, Class<?> clazz) {
        List<String> fields = Arrays.stream(clazz.getDeclaredFields()).map(Field::getName).toList();
        ReflectionHelper.setFieldsToNull(obj, clazz, fields);
    }

    public static <T> T cast(Object o) {
        if (o == null) {
            return null;
        }
        Object t = o;
        return (T)t;
    }

    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static VarHandle getFieldFromClass(Class<?> clazz, String fieldName, Class<?> fieldClass, boolean isStatic) {
        MethodHandles.Lookup lookup = ReflectionHelper.safeLookup(clazz);
        VarHandle handler = ReflectionHelper.safeVarHandler(lookup, clazz, fieldName, fieldClass, isStatic);
        if (handler == null) {
            throw new RuntimeException("VarHandler is null");
        }
        return handler;
    }

    @Nullable
    public static MethodHandles.Lookup safeLookup(Class<?> clazz) {
        MethodHandles.Lookup lookup = PRIVATE_LOOKUP.getOrDefault(clazz, null);
        if (lookup != null) {
            return lookup;
        }
        try {
            lookup = MethodHandles.privateLookupIn(clazz, LOOKUP);
        }
        catch (IllegalAccessException e) {
            AllTheLeaks.LOGGER.warn("Failed to get lookup for class {}", clazz);
        }
        PRIVATE_LOOKUP.put(clazz, lookup);
        return lookup;
    }

    @Nullable
    private static VarHandle safeVarHandler(MethodHandles.Lookup lookup, Class<?> clazz, String fieldName, Class<?> fieldClass, boolean isStatic) {
        VarHandle handler = null;
        if (lookup == null) {
            return null;
        }
        try {
            handler = isStatic ? lookup.findStaticVarHandle(clazz, fieldName, fieldClass) : lookup.findVarHandle(clazz, fieldName, fieldClass);
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.warn("Failed to get VarHandle for class {} with field {} and type {}", new Object[]{clazz, fieldName, fieldClass});
        }
        return handler;
    }

    public static Class<?> getPrivateClass(Class<?> parent, String subclass) {
        for (Class<?> clazz : parent.getNestMembers()) {
            if (!clazz.getName().equals(subclass)) continue;
            return clazz;
        }
        throw new RuntimeException("Sub class not found!");
    }

    @Nullable
    private static MethodHandle safeMethodHandler(MethodHandles.Lookup lookup, Class<?> clazz, String methodName, MethodType methodType, boolean isStatic) {
        MethodHandle handler = null;
        if (lookup == null) {
            return null;
        }
        try {
            handler = isStatic ? lookup.findStatic(clazz, methodName, methodType) : lookup.findVirtual(clazz, methodName, methodType);
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.warn("Failed to get MethodHandle for class {} with method {} and type {}", new Object[]{clazz, methodName, methodType});
        }
        return handler;
    }

    public static MethodHandle getMethodFromClass(Class<?> clazz, String methodName, MethodType methodType, boolean isStatic) {
        MethodHandles.Lookup lookup = ReflectionHelper.safeLookup(clazz);
        MethodHandle handler = ReflectionHelper.safeMethodHandler(lookup, clazz, methodName, methodType, isStatic);
        if (handler == null) {
            throw new RuntimeException("MethodHandler is null");
        }
        return handler;
    }
}

