/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.mixin;

import com.leclowndu93150.corpsecurioscompat.Config;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalContainer;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={CorpseInventoryContainer.class, CorpseAdditionalContainer.class})
public abstract class CorpseContainerMixin {
    private static final String CURIO_SLOT_TAG = "CorpseCuriosSlot";
    private static final String CURIO_SLOT_TYPE = "SlotType";
    private static final String CURIO_SLOT_INDEX = "SlotIndex";
    private static final String WAS_EQUIPPED = "WasEquipped";
    private Player cachedPlayer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(int id, Inventory playerInventory, CorpseEntity corpse, boolean editable, boolean history, CallbackInfo ci) {
        if (playerInventory != null) {
            this.cachedPlayer = playerInventory.f_35978_;
        }
    }

    @Inject(method={"transferItems"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void transferItemsToCurios(CallbackInfo ci) {
        block7: {
            Map curios;
            CorpseContainerMixin container;
            block6: {
                int i;
                container = this;
                if (this.cachedPlayer == null || !this.cachedPlayer.m_6084_()) {
                    return;
                }
                if (!((CorpseContainerBase)container).isEditable()) {
                    return;
                }
                Optional curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.cachedPlayer).resolve();
                if (curiosOpt.isEmpty()) {
                    return;
                }
                ICuriosItemHandler curiosHandler = (ICuriosItemHandler)curiosOpt.get();
                curios = curiosHandler.getCurios();
                if (!(container instanceof CorpseInventoryContainer)) break block6;
                CorpseInventoryContainer corpseContainer = (CorpseInventoryContainer)container;
                for (i = 0; i < corpseContainer.f_38839_.size() && i < corpseContainer.getInventorySize(); ++i) {
                    ItemStack stack;
                    Slot slot = corpseContainer.m_38853_(i);
                    if (slot == null || (stack = slot.m_7993_()).m_41619_() || !this.tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
                    slot.m_5852_(ItemStack.f_41583_);
                }
                for (i = 0; i < corpseContainer.getCorpse().getDeath().getAdditionalItems().size(); ++i) {
                    ItemStack stack = (ItemStack)corpseContainer.getCorpse().getDeath().getAdditionalItems().get(i);
                    if (stack.m_41619_() || !this.tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
                    corpseContainer.getCorpse().getDeath().getAdditionalItems().set(i, (Object)ItemStack.f_41583_);
                }
                break block7;
            }
            if (!(container instanceof CorpseAdditionalContainer)) break block7;
            CorpseAdditionalContainer additionalContainer = (CorpseAdditionalContainer)container;
            for (int i = 0; i < additionalContainer.getInventorySize(); ++i) {
                ItemStack stack;
                Slot slot = additionalContainer.m_38853_(i);
                if (slot == null || (stack = slot.m_7993_()).m_41619_() || !this.tryTransferPreviouslyEquippedCurio(stack, curios)) continue;
                slot.m_5852_(ItemStack.f_41583_);
            }
        }
    }

    private boolean tryTransferPreviouslyEquippedCurio(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        if (stack.m_41619_()) {
            return false;
        }
        if (CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).isEmpty()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(CURIO_SLOT_TAG)) {
            return false;
        }
        CompoundTag slotData = tag.m_128469_(CURIO_SLOT_TAG);
        boolean wasEquipped = slotData.m_128471_(WAS_EQUIPPED);
        if (!wasEquipped) {
            return false;
        }
        if (Config.isItemBlacklisted(stack.m_41720_())) {
            return false;
        }
        String slotType = slotData.m_128461_(CURIO_SLOT_TYPE);
        int slotIndex = slotData.m_128451_(CURIO_SLOT_INDEX);
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0 && slotIndex < handler.getSlots()) {
            try {
                CompoundTag existingSlotData;
                ItemStack existingStack = handler.getStacks().getStackInSlot(slotIndex);
                if (existingStack.m_41619_()) {
                    ItemStack cleanStack = stack.m_41777_();
                    this.cleanSlotData(cleanStack);
                    handler.getStacks().setStackInSlot(slotIndex, cleanStack);
                    return true;
                }
                CompoundTag existingTag = existingStack.m_41783_();
                if (existingTag != null && existingTag.m_128441_(CURIO_SLOT_TAG) && (!slotType.equals((existingSlotData = existingTag.m_128469_(CURIO_SLOT_TAG)).m_128461_(CURIO_SLOT_TYPE)) || slotIndex != existingSlotData.m_128451_(CURIO_SLOT_INDEX))) {
                    handler.getStacks().setStackInSlot(slotIndex, ItemStack.f_41583_);
                    ItemStack cleanStack = stack.m_41777_();
                    this.cleanSlotData(cleanStack);
                    handler.getStacks().setStackInSlot(slotIndex, cleanStack);
                    this.tryFindAlternativeSlot(existingStack, curios);
                    return true;
                }
            }
            catch (IndexOutOfBoundsException e) {
                return this.tryFindAlternativeSlot(stack, curios);
            }
        }
        return this.tryFindAlternativeSlot(stack, curios);
    }

    private boolean tryFindAlternativeSlot(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(CURIO_SLOT_TAG)) {
            return false;
        }
        CompoundTag slotData = tag.m_128469_(CURIO_SLOT_TAG);
        if (!slotData.m_128471_(WAS_EQUIPPED)) {
            return false;
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).contains(entry.getKey())) continue;
            ICurioStacksHandler handler = entry.getValue();
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                try {
                    if (!handler.getStacks().getStackInSlot(slot).m_41619_()) continue;
                    ItemStack cleanStack = stack.m_41777_();
                    this.cleanSlotData(cleanStack);
                    handler.getStacks().setStackInSlot(slot, cleanStack);
                    return true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private void cleanSlotData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(CURIO_SLOT_TAG)) {
            tag.m_128473_(CURIO_SLOT_TAG);
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }
}

