/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal;

import insane96mcp.enhancedai.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.modules.mobs.targeting.EANearestAttackableTarget;
import insane96mcp.enhancedai.setup.EAAttributes;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Animals Scared Attack", description="Make animals fight back or be scared by players. Use the entity type tag enhancedai:can_be_neutral, enhancedai:can_be_hostile, and enhancedai:can_be_scared_by_players to add/remove animals.")
@LoadFeature(module="enhancedai:animal")
public class AnimalScaredAttack
extends Feature {
    public static final TagKey<EntityType<?>> CAN_BE_NEUTRAL = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhancedai", (String)"can_be_neutral"));
    public static final TagKey<EntityType<?>> CAN_BE_HOSTILE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhancedai", (String)"can_be_hostile"));
    public static final TagKey<EntityType<?>> SCARED_BY_PLAYERS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhancedai", (String)"can_be_scared_by_players"));
    public static final String NEUTRAL = "enhancedai:neutral";
    public static final String HOSTILE = "enhancedai:hostile";
    public static final String PLAYER_SCARED = "enhancedai:player_scared";
    @Config(min=0.0, max=1.0)
    @Label(description="Animals have this percentage chance to be able to fight back instead of fleeing. Animals have a slightly bigger range to attack. Attack damage can't be changed via config due to limitations so use mods like Mobs Properties Randomness to change the damage. Base damage is 3")
    public static Double neutralChance = 0.35;
    @Config(min=0.0, max=1.0)
    @Label(description="Animals have this percentage chance to be hostile")
    public static Double hostileChance = 0.1;
    @Config(min=0.0, max=1.0)
    @Label(name="Players Scared chance", description="Animals have this percentage chance to be scared by players and run away. Fight back chance has priority over this")
    public static Double playersScaredChance = 0.25;
    @Config(min=0.0, max=4.0)
    @Label(name="Flee speed Multiplier Near", description="Speed multiplier when the animal avoids the player and it's within 8 blocks from him.")
    public static Double fleeSpeedNear = 1.1;
    @Config(min=0.0, max=4.0)
    @Label(name="Flee speed Multiplier Far", description="Speed multiplier when the animal avoids the player and it's farther than 16 blocks from him.")
    public static Double fleeSpeedFar = 1.0;
    @Config(min=0.0, max=4.0)
    @Label(name="Movement Speed Multiplier", description="Movement speed multiplier when aggroed.")
    public static Double speedMultiplier = 1.1;
    @Config(min=0.0, max=128.0)
    @Label(name="Knockback", description="Animals' knockback attribute will be set to this value.")
    public static Double knockback = 1.5;
    @Config
    @Label(name="Knockback size based", description="Animals' knockback attribute will be increased/decreased based on the side of the mob.")
    public static Boolean knockbackSizeBased = true;
    private static final double BASE_ATTACK_DAMAGE = 3.0;

    public AnimalScaredAttack(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void attribute(EntityAttributeModificationEvent event) {
        for (EntityType entityType : event.getTypes()) {
            if (event.has(entityType, Attributes.f_22281_)) continue;
            event.add(entityType, Attributes.f_22281_, 3.0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        CompoundTag persistentData = animal.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", speedMultiplier);
        boolean neutral = NBTUtils.getBooleanOrPutDefault(persistentData, NEUTRAL, animal.m_6095_().m_204039_(CAN_BE_NEUTRAL) && animal.m_217043_().m_188500_() < neutralChance);
        boolean hostile = NBTUtils.getBooleanOrPutDefault(persistentData, HOSTILE, animal.m_6095_().m_204039_(CAN_BE_HOSTILE) && !animal.m_6162_() && animal.m_217043_().m_188500_() < hostileChance);
        boolean playerScared = NBTUtils.getBooleanOrPutDefault(persistentData, PLAYER_SCARED, !neutral && animal.m_6095_().m_204039_(SCARED_BY_PLAYERS) && animal.m_217043_().m_188500_() < playersScaredChance);
        if (neutral || hostile) {
            animal.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)animal, new Class[0]).m_26044_(new Class[0]));
            animal.f_21345_.m_25352_(1, (Goal)new AnimalMeleeAttackGoal((PathfinderMob)animal, movementSpeedMultiplier, true));
            animal.f_21345_.f_25345_.removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof PanicGoal);
            if (knockback > 0.0) {
                AttributeInstance kbAttribute;
                double baseSize = 1.053;
                double actualKnockback = knockback;
                if (knockbackSizeBased.booleanValue()) {
                    actualKnockback = (double)(animal.m_20205_() * animal.m_20205_() * animal.m_20206_()) * knockback / baseSize;
                }
                if ((kbAttribute = animal.m_21051_(Attributes.f_22282_)) != null) {
                    kbAttribute.m_22125_(new AttributeModifier("Animal knockback", actualKnockback, AttributeModifier.Operation.ADDITION));
                }
            }
            if (hostile) {
                animal.f_21346_.m_25352_(2, new EANearestAttackableTarget<Player>((Mob)animal, Player.class, false, false, TargetingConditions.m_148352_()));
                MCUtils.applyModifier((LivingEntity)animal, (Attribute)Attributes.f_22277_, (UUID)UUID.fromString("62e016b0-90d0-4e72-9d40-fffac566df20"), (String)"Reduced follow range for hostile Animals", (double)-0.8, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)true);
                MCUtils.applyModifier((LivingEntity)animal, (Attribute)((Attribute)EAAttributes.XRAY_FOLLOW_RANGE.get()), (UUID)UUID.fromString("62e016b0-90d0-4e72-9d40-fffac566df20"), (String)"Reduced follow range for hostile Animals", (double)-0.8, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)true);
            }
        } else if (playerScared) {
            AnimalAvoidPlayersGoal avoidEntityGoal = new AnimalAvoidPlayersGoal((PathfinderMob)animal, Player.class, 16.0f, 8.0f, (double)fleeSpeedNear, (double)fleeSpeedFar);
            animal.f_21345_.m_25352_(1, (Goal)avoidEntityGoal);
        }
    }

    public static class AnimalMeleeAttackGoal
    extends MeleeAttackGoal {
        public AnimalMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            OwnableEntity ownableEntity;
            PathfinderMob pathfinderMob = this.f_25540_;
            if (pathfinderMob instanceof OwnableEntity && (ownableEntity = (OwnableEntity)pathfinderMob).m_269323_() != null) {
                return false;
            }
            return !this.f_25540_.m_6162_() && super.m_8036_();
        }
    }

    public static class AnimalAvoidPlayersGoal
    extends EAAvoidEntityGoal<Player> {
        public AnimalAvoidPlayersGoal(PathfinderMob entity, Class<Player> classToAvoidIn, float avoidDistance, float avoidDistanceNear, double nearSpeed, double farSpeed) {
            super(entity, classToAvoidIn, avoidDistance, avoidDistanceNear, nearSpeed, farSpeed);
        }

        @Override
        public boolean m_8036_() {
            OwnableEntity ownableEntity;
            PathfinderMob pathfinderMob = this.goalOwner;
            if (pathfinderMob instanceof OwnableEntity && (ownableEntity = (OwnableEntity)pathfinderMob).m_269323_() != null) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

