/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.animal;

import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Not Tempted Animals", description="Makes animals not tempted by food. Use the entity type tag enhancedai:can_ignore_food_temptation to change animals.")
@LoadFeature(module="enhancedai:animal")
public class NotTemptedAnimals
extends Feature {
    public static final TagKey<EntityType<?>> CAN_IGNORE_FOOD_TEMPTATION = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "can_ignore_food_temptation"));
    public static final String NOT_TEMPTED = "enhancedai:not_tempted";
    @Config(min=0.0, max=1.0)
    @Label(name="Not tempted chance", description="Animals have this percentage chance to not be temped by food.")
    public static Double notTemptedChance = 0.5;

    public NotTemptedAnimals(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getEntity() instanceof Enemy || !((entity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        CompoundTag persistentData = animal.getPersistentData();
        boolean notTempted = NBTUtils.getBooleanOrPutDefault(persistentData, NOT_TEMPTED, animal.m_6095_().m_204039_(CAN_IGNORE_FOOD_TEMPTATION) && animal.m_217043_().m_188500_() < notTemptedChance);
        if (notTempted) {
            animal.f_21345_.m_148105_().removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof TemptGoal);
        }
    }
}

