/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.blaze;

import insane96mcp.enhancedai.modules.blaze.EABlazeAttackGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Blaze Attack", description="Make blazes fire faster/more fireballs. Only mobs in enhancedai:change_blaze_attack entity type tag are affected by this feature.")
@LoadFeature(module="enhancedai:blaze")
public class BlazeAttack
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_BLAZE_ATTACK = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "change_blaze_attack"));
    public static final String TIME_BETWEEN_FIREBALLS = "enhancedai:time_between_fireballs";
    public static final String FIREBALLS_SHOT = "enhancedai:fireballs_shot";
    public static final String RECHARGE_TIME = "enhancedai:recharge_time";
    public static final String CHARGE_TIME = "enhancedai:charge_time";
    public static final String FIREBALLS_PER_SHOT = "enhancedai:fireballs_per_shot";
    public static final String INACCURACY = "enhancedai:inaccuracy";
    @Config(min=1.0, max=300.0)
    @Label(name="Time Between Fireballs", description="How many ticks pass between shooting fireballs. Vanilla is 6")
    public static MinMax timeBetweenFireballs = new MinMax(4.0, 10.0);
    @Config(min=1.0, max=64.0)
    @Label(name="Fireballs shot", description="How many fireballs blazes shoots. Vanilla is 3")
    public static MinMax fireballsShot = new MinMax(2.0, 6.0);
    @Config(min=1.0, max=600.0)
    @Label(name="Recharge time", description="Time (in ticks) taken by the blaze to recharge (before setting himself on fire). Vanilla is 100")
    public static MinMax rechargeTime = new MinMax(60.0, 120.0);
    @Config(min=1.0, max=600.0)
    @Label(name="Charge time", description="Time (in ticks) taken by the blaze to charge (while on fire before shooting fireballs). Vanilla is 60")
    public static MinMax chargeTime = new MinMax(30.0, 80.0);
    @Config(min=1.0, max=8.0)
    @Label(name="Fireballs Per Shot", description="How many fireballs are shot per shot. Vanilla is 1")
    public static MinMax fireballsPerShot = new MinMax(1.0, 2.0);
    @Config(min=-1.0, max=32.0)
    @Label(name="Inaccuracy", description="The higher the more spread up shots will be. Setting both to -1 will use the vanilla behaviour (farther = more inaccuracy)")
    public static MinMax inaccuracy = new MinMax(2.0, 14.0);

    public BlazeAttack(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Blaze blaze;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Blaze && (blaze = (Blaze)entity).m_6095_().m_204039_(CHANGE_BLAZE_ATTACK))) {
            return;
        }
        CompoundTag persistentData = blaze.getPersistentData();
        int timeBetweenFireballs1 = NBTUtils.getIntOrPutDefault(persistentData, TIME_BETWEEN_FIREBALLS, timeBetweenFireballs.getIntRandBetween(blaze.m_217043_()));
        int fireballsShot1 = NBTUtils.getIntOrPutDefault(persistentData, FIREBALLS_SHOT, fireballsShot.getIntRandBetween(blaze.m_217043_()));
        int rechargeTime1 = NBTUtils.getIntOrPutDefault(persistentData, RECHARGE_TIME, rechargeTime.getIntRandBetween(blaze.m_217043_()));
        int chargeTime1 = NBTUtils.getIntOrPutDefault(persistentData, CHARGE_TIME, chargeTime.getIntRandBetween(blaze.m_217043_()));
        int fireballsPerShot1 = NBTUtils.getIntOrPutDefault(persistentData, FIREBALLS_PER_SHOT, fireballsPerShot.getIntRandBetween(blaze.m_217043_()));
        int inaccuracy1 = NBTUtils.getIntOrPutDefault(persistentData, INACCURACY, inaccuracy.getIntRandBetween(blaze.m_217043_()));
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        blaze.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Blaze.BlazeAttackGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)blaze.f_21345_).m_25363_(arg_0));
        blaze.f_21345_.m_25352_(4, (Goal)new EABlazeAttackGoal(blaze).setTimeBetweenFireballs(timeBetweenFireballs1).setFireballShot(fireballsShot1).setRechargeTime(rechargeTime1).setChargeTime(chargeTime1).setFireballsPerShot(fireballsPerShot1).setInaccuracy(inaccuracy1));
    }
}

