/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper;

import insane96mcp.enhancedai.modules.creeper.EACreeperLaunchGoal;
import insane96mcp.enhancedai.modules.creeper.EACreeperSwellGoal;
import insane96mcp.enhancedai.setup.EASounds;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.module.base.TagsFeature;
import insane96mcp.insanelib.network.MessageCreeperDataSync;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Creeper Swell", description="Various changes to Creepers exploding. Ignoring Walls, Walking Fuse and smarter exploding based off explosion size. Only creepers in the enhancedai:change_creeper_swell entity type tag are affected by this feature.")
@LoadFeature(module="enhancedai:creeper")
public class CreeperSwell
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_CREEPER_SWELL = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhancedai", (String)"change_creeper_swell"));
    public static final TagKey<EntityType<?>> CAN_CREEPER_LAUNCH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"enhancedai", (String)"can_creeper_launch"));
    public static final String LAUNCH = "enhancedai:launch";
    public static final String BREACH = "enhancedai:breach";
    public static final String ANGRY = "enhancedai:angry";
    public static final String WALKING_FUSE = "enhancedai:walking_fuse";
    public static final String IGNORE_WALLS = "enhancedai:ignore_walls";
    public static final String BETA = "enhancedai:beta";
    @Config(min=0.0, max=1.0)
    @Label(name="Walking Fuse Chance", description="Percentage chance for a Creeper to keep walking while exploding. This is overwritten if the creeper has the beta property.")
    public static Double walkingFuseChance = 0.1;
    @Config(min=-1.0, max=64.0)
    @Label(name="Walking Fuse Speed Modifier", description="Speed modifier when a walking fuse creeper is swelling.")
    public static Double walkingFuseSpeedModifier = -0.5;
    @Config(min=0.0, max=1.0)
    @Label(name="Ignore Walls Chance", description="Percentage chance for a Creeper to ignore walls while targeting a player. This means that a creeper will be able to explode if it's in the correct range from a player even if there's a wall between.")
    public static Double ignoreWallsChance = 0.65;
    @Config(min=0.0, max=1.0)
    @Label(name="Launch.Chance", description="Launching creepers will try ignite and throw themselves at the player.")
    public static Double launchChance = 0.05;
    @Config
    @Label(name="Launch.Particles", description="If true, Launching Creepers emit particles")
    public static Boolean launchParticles = true;
    @Config(min=0.0, max=8.0)
    @Label(name="Launch.inaccuracy", description="The inaccuracy of the launching creeper in Normal difficulty, easy is increased, hard is decreased.")
    public static Double launchInaccuracy = 0.5;
    @Config(min=0.0, max=127.0)
    @Label(name="Launch.Explosion Radius", description="The explosion radius of launching creepers. Set to 0 to not change. (Overrides Cena creepers explosion radius)")
    public static Integer launchExplosionRadius = 2;
    @Config(min=0.0, max=1.0)
    @Label(name="Breach.Chance", description="Breaching creepers will try to open a hole in the wall to let mobs in.")
    public static Double breachChance = 0.075;
    @Config(min=0.0)
    @Label(name="Breach.Horizontal Range", description="How far away (horizontally) from the target breaching creepers can breach.")
    public static Integer breachHorizontalRange = 24;
    @Config(min=0.0, max=1.0)
    @Label(name="Beta Creeper Chance", description="Beta creepers when exploding will walk around the target, like the creepers in pre-1.2.")
    public static Double betaCreeperChance = 0.35;
    @Config
    @Label(name="Disable falling swelling", description="Disables the creeper feature that makes them start swelling when falling.")
    public static Boolean disableFallingSwelling = true;
    @Config
    @Label(name="TNT Like", description="If true creepers will ignite if damaged by an explosion.")
    public static Boolean tntLike = false;
    @Config(min=0.0, max=1.0)
    @Label(name="Angry Creeper.Chance", description="Chance for a creeper to spawn angry")
    public static Double angryChance = 0.03;
    @Config
    @Label(name="Angry Creeper.Particles", description="If true, Angry Creeper emits particles")
    public static Boolean angryParticles = true;
    @Config
    @Label(name="Angry Creeper.Sounds", description="The special sound effect that the Angry Creeper plays")
    public static AngryCreeperSounds angryCreeperSounds = AngryCreeperSounds.OLD_EXPLOSION;
    @Config
    @Label(name="Angry Creeper.Name", description="If true, Angry Creeper will have a name")
    public static Boolean angryName = true;
    @Config
    @Label(name="Angry Creeper.Forced Explosion", description="When ignited, Angry Creeper will not stop swelling")
    public static Boolean angryForceExplosion = false;
    @Config
    @Label(name="Angry Creeper.Explode on death", description="Makes angry creepers blow up on death like when they were added back in 0.30")
    public static Boolean angryExplodeOnDeath = true;
    @Config
    @Label(name="Angry Creeper.Generates fire", description="If true, Angry Creeper explosion will generate fire")
    public static Boolean angryFire = false;
    @Config(min=0.0, max=12.0)
    @Label(name="Angry Creeper.Explosion power", description="Explosion power of Angry Creeper")
    public static Double angryExplosionPower = 4.0;
    @Config
    @Label(name="Blow up on death", description="Makes creepers blow up on death like when they were added back in 0.30")
    public static BlowUpOnDeath blowUpOnDeath = BlowUpOnDeath.CHARGED;
    @Config
    @Label(name="IguanaTweaks Reborn Integration", description="If IguanaTweaks Reborn is installed and Explosion Overhaul is enabled, Angry creeper will deal more knockback and break more blocks and breaching creepers will break more blocks")
    public static Boolean iguanaTweaksIntegration = true;

    public CreeperSwell(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void explosionStartEvent(ExplosionEvent.Detonate event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion e = event.getExplosion();
        Entity entity = e.getExploder();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        if (creeper.getPersistentData().m_128471_(ANGRY) && CreeperSwell.angryCreeperSounds.explode != null) {
            creeper.m_5496_(CreeperSwell.angryCreeperSounds.explode.get(), 4.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinLevelEvent event) {
        Creeper creeper;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Creeper) || !(creeper = (Creeper)entity).m_6095_().m_204039_(CHANGE_CREEPER_SWELL)) {
            return;
        }
        boolean hasSwellGoal = false;
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        for (WrappedGoal prioritizedGoal : creeper.f_21345_.f_25345_) {
            if (!(prioritizedGoal.m_26015_() instanceof SwellGoal)) continue;
            goalsToRemove.add(prioritizedGoal.m_26015_());
            hasSwellGoal = true;
        }
        if (!hasSwellGoal) {
            return;
        }
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)creeper.f_21345_).m_25363_(arg_0));
        CompoundTag persistentData = creeper.getPersistentData();
        boolean walkingFuse = NBTUtils.getBooleanOrPutDefault(persistentData, WALKING_FUSE, creeper.m_217043_().m_188500_() < walkingFuseChance);
        boolean ignoreWalls = NBTUtils.getBooleanOrPutDefault(persistentData, IGNORE_WALLS, creeper.m_217043_().m_188500_() < ignoreWallsChance);
        boolean breach = NBTUtils.getBooleanOrPutDefault(persistentData, BREACH, creeper.m_217043_().m_188500_() < breachChance);
        boolean launch = creeper.m_6095_().m_204039_(CAN_CREEPER_LAUNCH) && NBTUtils.getBooleanOrPutDefault(persistentData, LAUNCH, creeper.m_217043_().m_188500_() < launchChance);
        boolean angry = NBTUtils.getBooleanOrPutDefault(persistentData, ANGRY, creeper.m_217043_().m_188500_() < angryChance);
        boolean beta = NBTUtils.getBooleanOrPutDefault(persistentData, BETA, creeper.m_217043_().m_188500_() < betaCreeperChance);
        CompoundTag compoundNBT = new CompoundTag();
        creeper.m_7380_(compoundNBT);
        if (angry) {
            compoundNBT.m_128376_("Fuse", (short)36);
            compoundNBT.m_128344_("ExplosionRadius", angryExplosionPower.byteValue());
            if (angryName.booleanValue()) {
                creeper.m_6593_((Component)Component.m_237113_((String)"Angry Creeper"));
            }
            if (angryFire.booleanValue()) {
                TagsFeature.setExplosionCausesFire((boolean)true, (LivingEntity)creeper);
            }
            if (iguanaTweaksIntegration.booleanValue()) {
                persistentData.m_128350_("iguanatweaksreborn:explosion_knockback_multiplier", 2.0f);
                persistentData.m_128350_("iguanatweaksreborn:explosion_ray_strength_multiplier", 0.01f);
            }
        }
        EACreeperSwellGoal swellGoal = new EACreeperSwellGoal(creeper).setWalkingFuse(walkingFuse && !beta).setIgnoreWalls(ignoreWalls).setBreaching(breach).setBeta(beta);
        if (angry && angryForceExplosion.booleanValue()) {
            swellGoal.setForceExplode(angryForceExplosion);
        }
        creeper.f_21345_.m_25352_(2, (Goal)swellGoal);
        if (launch) {
            creeper.f_21345_.m_25352_(1, (Goal)new EACreeperLaunchGoal(creeper));
            if (launchExplosionRadius > 0) {
                compoundNBT.m_128344_("ExplosionRadius", launchExplosionRadius.byteValue());
            }
        }
        creeper.m_7378_(compoundNBT);
        MessageCreeperDataSync.syncCreeperToPlayers((Creeper)creeper);
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && tntLike.booleanValue() && event.getSource().m_269533_(DamageTypeTags.f_268415_) && (livingEntity = event.getEntity()) instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)livingEntity;
        creeper.m_32312_();
    }

    @SubscribeEvent
    public void onCreeperRemoved(EntityLeaveLevelEvent event) {
        Creeper creeper;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Creeper) || !(creeper = (Creeper)entity).m_21224_() || creeper.m_9236_().f_46443_) {
            return;
        }
        if (blowUpOnDeath == BlowUpOnDeath.ALL || blowUpOnDeath == BlowUpOnDeath.CHARGED && creeper.m_7090_() || creeper.getPersistentData().m_128471_(ANGRY) && angryExplodeOnDeath.booleanValue()) {
            float f = creeper.m_7090_() ? 2.0f : 1.0f;
            creeper.m_9236_().m_254849_((Entity)creeper, creeper.m_20185_(), creeper.m_20186_(), creeper.m_20189_(), (float)creeper.f_32272_ * f, Level.ExplosionInteraction.MOB);
            creeper.m_32316_();
        }
    }

    @SubscribeEvent
    public void onCreeperTick(LivingEvent.LivingTickEvent event) {
        Creeper creeper;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Creeper)) break block2;
                creeper = (Creeper)livingEntity;
                if (!creeper.m_9236_().f_46443_) break block3;
            }
            return;
        }
        this.onLaunchCreeperTick(creeper);
        this.onCenaCreeperTick(creeper);
    }

    public void onLaunchCreeperTick(Creeper creeper) {
        if (creeper.f_19797_ % 20 != 0 || !launchParticles.booleanValue()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)creeper.m_9236_();
        if (creeper.getPersistentData().m_128471_(LAUNCH)) {
            for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
                serverLevel.m_8624_(serverplayer, (ParticleOptions)ParticleTypes.f_123796_, true, creeper.m_20185_(), creeper.m_20186_() + 0.25, creeper.m_20189_(), 8, 0.05, 0.05, 0.05, 0.025);
            }
        }
    }

    public void onCenaCreeperTick(Creeper creeper) {
        if (creeper.f_19797_ % 40 != 5 || !angryParticles.booleanValue()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)creeper.m_9236_();
        if (creeper.getPersistentData().m_128471_(ANGRY)) {
            for (int j = 0; j < serverLevel.m_6907_().size(); ++j) {
                ServerPlayer serverplayer = (ServerPlayer)serverLevel.m_6907_().get(j);
                BlockPos blockpos = serverplayer.m_20183_();
                if (!blockpos.m_203195_((Position)new Vec3(creeper.m_20185_(), creeper.m_20186_() + 0.5, creeper.m_20189_()), 16.0)) continue;
                serverLevel.m_8624_(serverplayer, (ParticleOptions)ParticleTypes.f_123792_, false, creeper.m_20185_(), creeper.m_20186_() + 1.1, creeper.m_20189_(), 1, 0.15, 0.15, 0.15, 0.0);
            }
        }
    }

    public static boolean shouldDisableFallingSwelling() {
        return Feature.isEnabled(CreeperSwell.class) && disableFallingSwelling != false;
    }

    public static enum AngryCreeperSounds {
        NONE(null, null),
        CENA((Supplier<SoundEvent>)EASounds.CREEPER_CENA_FUSE, (Supplier<SoundEvent>)EASounds.CREEPER_CENA_EXPLODE),
        WTF_BOOM((Supplier<SoundEvent>)EASounds.WTF_BOOM_FUSE, (Supplier<SoundEvent>)EASounds.WTF_BOOM_EXPLODE),
        OLD_EXPLOSION(() -> SoundEvents.f_11837_, (Supplier<SoundEvent>)EASounds.OLD_EXPLODE);

        @Nullable
        public final Supplier<SoundEvent> fuse;
        @Nullable
        public final Supplier<SoundEvent> explode;

        private AngryCreeperSounds(Supplier<SoundEvent> fuse, Supplier<SoundEvent> explode) {
            this.fuse = fuse;
            this.explode = explode;
        }
    }

    public static enum BlowUpOnDeath {
        NONE,
        CHARGED,
        ALL;

    }
}

