/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.ghast;

import insane96mcp.enhancedai.modules.ghast.GhastShootFireballGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Ghast Shoot", description="Various changes to ghast shooting. Only ghasts in enhancedai:change_ghast_shooting entity type tag are affected by this feature.")
@LoadFeature(module="enhancedai:ghast")
public class GhastShoot
extends Feature {
    public static final TagKey<EntityType<?>> CHANGE_GHAST_SHOOT = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "change_ghast_shoot"));
    public static final String ATTACK_COOLDOWN = "enhancedai:attack_cooldown";
    public static final String FIREBALLS_SHOT = "enhancedai:fireballs_shot";
    public static final String SHOOT_WHEN_NOT_SEEN = "enhancedai:shoot_when_not_seen";
    @Config(min=1.0, max=300.0)
    @Label(name="Attack Cooldown", description="How many ticks pass between shooting fireballs. Vanilla is 40")
    public static MinMax attackCooldown = new MinMax(40.0, 50.0);
    @Config(min=1.0, max=16.0)
    @Label(name="Fireballs shot", description="How many fireballs ghast shoot in rapid succession. Vanilla is 1")
    public static MinMax fireballsShot = new MinMax(1.0, 3.0);
    @Config(min=0.0, max=1.0)
    @Label(name="Shoot when not seen Chance", description="Chance for a Ghast to try and shoot the target even if can't see it. If enabled and the Ghast can't see the target, he will shoot 4 times as fast to breach.")
    public static Double shootWhenNotSeenChance = 0.3;

    public GhastShoot(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Ghast ghast;
        Entity entity;
        if (!(this.isEnabled() && (entity = event.getEntity()) instanceof Ghast && (ghast = (Ghast)entity).m_6095_().m_204039_(CHANGE_GHAST_SHOOT))) {
            return;
        }
        CompoundTag persistentData = ghast.getPersistentData();
        int attackCooldown1 = NBTUtils.getIntOrPutDefault(persistentData, ATTACK_COOLDOWN, attackCooldown.getIntRandBetween(ghast.m_217043_()));
        int fireballsShot1 = NBTUtils.getIntOrPutDefault(persistentData, FIREBALLS_SHOT, fireballsShot.getIntRandBetween(ghast.m_217043_()));
        boolean shootWhenNotSeen = NBTUtils.getBooleanOrPutDefault(persistentData, SHOOT_WHEN_NOT_SEEN, ghast.m_217043_().m_188500_() < shootWhenNotSeenChance);
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        ghast.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Ghast.GhastShootFireballGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)ghast.f_21345_).m_25363_(arg_0));
        ghast.f_21345_.m_25352_(4, (Goal)new GhastShootFireballGoal(ghast).setAttackCooldown(attackCooldown1).setFireballsToShot(fireballsShot1).setIgnoreLineOfSight(shootWhenNotSeen));
    }
}

