/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton;

import insane96mcp.enhancedai.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.ai.EAAvoidTargetGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;

@Label(name="Skeleton Flee", description="Skeletons try to stay away from the target. Use the enhancedai:skeleton_flee entity type tag to add/remove skeletons that are affected by this feature")
@LoadFeature(module="enhancedai:skeleton")
public class SkeletonFleeTarget
extends Feature {
    public static final TagKey<EntityType<?>> SKELETON_FLEE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "skeleton_flee"));
    @Config(min=0.0, max=1.0)
    @Label(name="Avoid Player chance", description="Chance for a Skeleton to spawn with the ability to avoid the player")
    public static Double avoidPlayerChance = 0.5;
    @Config(min=0.0, max=1.0)
    @Label(name="Attack When Avoiding Chance", description="Chance for a Skeleton to be able to shoot while running from a player")
    public static Double attackWhenAvoidingChance = 0.5;
    @Config(min=0.0, max=32.0)
    @Label(name="Flee Distance Near", description="Distance from a player that counts as near and will make the skeleton run away faster.")
    public static Double fleeDistanceNear = 8.0;
    @Config(min=0.0, max=32.0)
    @Label(name="Flee Distance Far", description="Distance from a player that will make the skeleton run away.")
    public static Double fleeDistanceFar = 16.0;
    @Config(min=0.0, max=4.0)
    @Label(name="Flee speed Multiplier Near", description="Speed multiplier when the skeleton avoids the player and it's within 'Flee Distance Near' blocks from him.")
    public static Double fleeSpeedNear = 1.25;
    @Config(min=0.0, max=4.0)
    @Label(name="Flee speed Multiplier Far", description="Speed multiplier when the skeleton avoids the player and it's farther than 'Flee Distance Far' blocks from him.")
    public static Double fleeSpeedFar = 1.1;

    public SkeletonFleeTarget(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!SkeletonFleeTarget.isEnabled(SkeletonFleeTarget.class) || !skeleton.m_6095_().m_204039_(SKELETON_FLEE)) {
            return;
        }
        CompoundTag persistentData = skeleton.getPersistentData();
        boolean avoidTarget = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:avoid_target", skeleton.m_217043_().m_188500_() < avoidPlayerChance);
        if (!avoidTarget) {
            return;
        }
        boolean attackWhenAvoiding = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:attack_when_avoiding", skeleton.m_217043_().m_188500_() < attackWhenAvoidingChance);
        double fleeDistanceFar1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_far", fleeDistanceFar);
        double fleeDistanceNear1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_distance_near", fleeDistanceNear);
        double fleeSpeedFar1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_far", fleeSpeedFar);
        double fleeSpeedNear1 = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:flee_speed_near", fleeSpeedNear);
        boolean hasAIArrowAttack = false;
        for (WrappedGoal prioritizedGoal : skeleton.f_21345_.f_25345_) {
            if (!prioritizedGoal.m_26015_().equals(skeleton.f_32130_)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof EAAvoidEntityGoal).toList();
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.f_21345_).m_25363_(arg_0));
        if (hasAIArrowAttack) {
            EAAvoidTargetGoal avoidTargetGoal = new EAAvoidTargetGoal((PathfinderMob)skeleton, (float)fleeDistanceFar1, (float)fleeDistanceNear1, fleeSpeedNear1, fleeSpeedFar1);
            avoidTargetGoal.setAttackWhenRunning(attackWhenAvoiding);
            skeleton.f_21345_.m_25352_(1, (Goal)avoidTargetGoal);
        }
    }
}

