/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.shoot;

import insane96mcp.enhancedai.ai.EARangedAttackGoal;
import insane96mcp.enhancedai.setup.Reflection;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class EARangedBowAttackGoal
extends EARangedAttackGoal<AbstractSkeleton> {
    protected int bowChargeTicks;

    public EARangedBowAttackGoal(AbstractSkeleton mob, double moveSpeedAmpIn, float maxAttackDistanceIn, boolean canStrafe) {
        super(mob, moveSpeedAmpIn, maxAttackDistanceIn, canStrafe);
    }

    public EARangedBowAttackGoal setBowChargeTicks(int bowChargeTicks) {
        this.bowChargeTicks = bowChargeTicks;
        return this;
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return ((AbstractSkeleton)this.mob).m_21093_(stack -> stack.m_41720_() instanceof BowItem);
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.isBowInMainhand();
    }

    @Override
    protected void attackTick(LivingEntity target, double distanceFromTarget, boolean canSeeTarget) {
        int ticksUsingItem = ((AbstractSkeleton)this.mob).m_21252_();
        if (ticksUsingItem > 12) {
            ((AbstractSkeleton)this.mob).m_21573_().m_26573_();
            ((AbstractSkeleton)this.mob).m_21391_((Entity)target, 30.0f, 30.0f);
            ((AbstractSkeleton)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        } else if (this.strafingTime > -1 && this.canStrafe()) {
            if (distanceFromTarget > (double)(this.maxAttackDistance * 0.9f)) {
                this.strafingBackwards = false;
            } else if (distanceFromTarget < (double)(this.maxAttackDistance * 0.8f)) {
                this.strafingBackwards = true;
            }
            ((AbstractSkeleton)this.mob).m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
        }
        ((AbstractSkeleton)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (((AbstractSkeleton)this.mob).m_6117_()) {
            if (!canSeeTarget && this.seeTime < -60) {
                ((AbstractSkeleton)this.mob).m_5810_();
            } else if (canSeeTarget && ticksUsingItem >= this.getBowChargeTicks(target)) {
                ((AbstractSkeleton)this.mob).m_5810_();
                this.attackEntityWithRangedAttack((AbstractSkeleton)this.mob, target, ticksUsingItem);
                this.attackTime = this.getAttackCooldown(target);
            }
        } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
            ((AbstractSkeleton)this.mob).m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.mob, item -> item == Items.f_42411_));
        }
    }

    private int getAttackCooldown(LivingEntity target) {
        return this.attackCooldown;
    }

    private int getBowChargeTicks(LivingEntity target) {
        double distanceFromTarget = ((AbstractSkeleton)this.mob).m_20280_((Entity)target);
        if (distanceFromTarget < 144.0) {
            return this.bowChargeTicks;
        }
        return (int)((double)this.bowChargeTicks + Math.sqrt(distanceFromTarget -= 144.0));
    }

    @Override
    protected void attackEntityWithRangedAttack(AbstractSkeleton entity, LivingEntity target, int chargeTicks) {
        ItemStack itemstack = entity.m_6298_(entity.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)entity, item -> item == Items.f_42411_)));
        double distance = entity.m_20270_((Entity)target);
        double distanceY = target.m_20186_() - entity.m_20186_();
        float f = 1.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        AbstractArrow abstractarrowentity = Reflection.AbstractSkeleton_getArrow(entity, itemstack, BowItem.m_40661_((int)chargeTicks));
        if (entity.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)entity.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double dirX = target.m_20185_() - entity.m_20185_();
        double dirZ = target.m_20189_() - entity.m_20189_();
        double distanceXZ = Math.sqrt(dirX * dirX + dirZ * dirZ);
        double yPos = target.m_20227_(0.0);
        yPos += (double)target.m_20192_() * 0.5;
        if (distanceXZ != 0.0) {
            yPos += distanceY / distanceXZ;
        }
        double dirY = yPos - abstractarrowentity.m_20186_();
        abstractarrowentity.m_6686_(dirX, dirY + distanceXZ * 0.17, dirZ, f * 1.1f + (float)distance / 32.0f + (float)Math.max(distanceY / 48.0, 0.0), this.inaccuracy);
        entity.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (entity.m_217043_().m_188501_() * 0.4f + 0.8f));
        entity.m_9236_().m_7967_((Entity)abstractarrowentity);
    }
}

