/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.throwing;

import insane96mcp.enhancedai.data.PotionOrMobEffect;
import insane96mcp.enhancedai.modules.witch.throwing.WitchThrowPotionGoal;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Witch Potion Throwing", description="Witches throw potions farther, faster and more potion types. Also no longer chase player if they can't see him. Use the enhancedai:better_potion_throwing entity type tag to add more witches that are affected by this feature.")
@LoadFeature(module="enhancedai:witch")
public class WitchPotionThrowing
extends Feature {
    public static final TagKey<EntityType<?>> BETTER_POTION_THROWING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("enhancedai", "better_potion_throwing"));
    public static final String APPRENTICE = "enhancedai:apprentice";
    public static final String ATTACK_SPEED = "enhancedai:attack_speed";
    public static final String ATTACK_RANGE = "enhancedai:attack_range";
    public static final String LINGERING_CHANCE = "enhancedai:lingering_chance";
    public static final String ANOTHER_THROW_CHANCE = "enhancedai:another_throw_chance";
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> badPotionsListConfig;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> goodPotionsListConfig;
    public static final List<String> badPotionsListDefault;
    public static final List<String> goodPotionsListDefault;
    public static ArrayList<PotionOrMobEffect> badPotionsList;
    public static ArrayList<PotionOrMobEffect> goodPotionsList;
    @Config(min=0.0, max=1.0)
    @Label(name="Lingering Chance", description="Chance for the potions thrown by the Witch to be lingering.")
    public static Double lingeringChance;
    @Config(min=0.0, max=1.0)
    @Label(name="Another Throw Chance", description="Chance for the Witch to throw another random potion right after she threw one.")
    public static Double anotherThrowChance;
    @Config(min=1.0)
    @Label(name="Throw Speed", description="Speed at which Witches throw potions (in ticks).")
    public static MinMax throwSpeed;
    @Config(min=8.0, max=64.0)
    @Label(name="Throw Range", description="Range at which Witches throw potions.")
    public static MinMax throwRange;
    @Config(min=0.0, max=1.0)
    @Label(name="Apprentice Witch.Chance", description="Chance for a Witch to be an apprentice. Apprentice Witches throw random potions instead of in order, and have a chance to throw a wrong (good) potion.")
    public static Double apprenticeWitchChance;
    @Config
    @Label(name="Use Slow Falling", description="If true, witches will throw a potion of slow falling at their feet when they're falling for more than 8 blocks.")
    public static Boolean useSlowFalling;
    @Config(min=0.0, max=1.0)
    @Label(name="Health Threshold Invisibility", description="When below this health percentage Witches will throw Invisibility potions at their feet.")
    public static Double healthThresholdInvisibility;

    public WitchPotionThrowing(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void loadConfigOptions() {
        super.loadConfigOptions();
        badPotionsListConfig = this.getBuilder().comment("A list of potions that the witch can throw at enemies. Format is effect_id,duration,amplifier. The potions are thrown in order and witches will not throw the same potion if the target has already the effect.").defineList("Bad Potions List", badPotionsListDefault, o -> o instanceof String);
        goodPotionsListConfig = this.getBuilder().comment("A list of potions that the witch can throw at allies (in raids). Format is effect_id,duration,amplifier. The potions are thrown in order and witches will not throw the same potion if the target has already the effect.").defineList("Good Potions List", goodPotionsListDefault, o -> o instanceof String);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        badPotionsList = PotionOrMobEffect.parseList((List)badPotionsListConfig.get());
        goodPotionsList = PotionOrMobEffect.parseList((List)goodPotionsListConfig.get());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Witch witch;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof Witch) || !(witch = (Witch)entity).m_6095_().m_204039_(BETTER_POTION_THROWING)) {
            return;
        }
        CompoundTag persistentData = witch.getPersistentData();
        int attackSpeed = NBTUtils.getIntOrPutDefault(persistentData, ATTACK_SPEED, throwSpeed.getIntRandBetween(witch.m_217043_()));
        int attackRange = NBTUtils.getIntOrPutDefault(persistentData, ATTACK_RANGE, throwRange.getIntRandBetween(witch.m_217043_()));
        double lingeringChance1 = NBTUtils.getDoubleOrPutDefault(persistentData, LINGERING_CHANCE, lingeringChance);
        double anotherThrowChance1 = NBTUtils.getDoubleOrPutDefault(persistentData, ANOTHER_THROW_CHANCE, anotherThrowChance);
        boolean apprentice = NBTUtils.getBooleanOrPutDefault(persistentData, APPRENTICE, witch.m_217043_().m_188500_() < apprenticeWitchChance);
        List<Goal> rangedAttackGoals = witch.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof RangedAttackGoal).toList();
        rangedAttackGoals.forEach(arg_0 -> ((GoalSelector)witch.f_21345_).m_25363_(arg_0));
        witch.f_21345_.m_25352_(2, (Goal)new WitchThrowPotionGoal(witch, attackSpeed, attackSpeed, attackRange, lingeringChance1, anotherThrowChance1, apprentice));
    }

    public static boolean shouldUseSlowFalling() {
        return WitchPotionThrowing.isEnabled(WitchPotionThrowing.class) && useSlowFalling != false;
    }

    static {
        badPotionsListDefault = List.of("minecraft:weakness", "minecraft:slowness", "minecraft:hunger,600,0", "minecraft:mining_fatigue,600,0", "minecraft:poison", "minecraft:blindness,120,0", "minecraft:strong_harming");
        goodPotionsListDefault = List.of("minecraft:regeneration", "minecraft:swiftness", "minecraft:strength", "minecraft:healing");
        lingeringChance = 0.15;
        anotherThrowChance = 0.2;
        throwSpeed = new MinMax(70.0, 90.0);
        throwRange = new MinMax(16.0, 24.0);
        apprenticeWitchChance = 0.6;
        useSlowFalling = true;
        healthThresholdInvisibility = 0.4;
    }
}

