/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.render.immediate.consumer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class VertexConsumersMixin {

    @Mixin(targets={"com/mojang/blaze3d/vertex/VertexMultiConsumer$Multiple"})
    public static class UnionMixin
    implements VertexBufferWriter {
        @Shadow
        @Final
        private VertexConsumer[] f_167071_;
        private boolean isFullWriter;

        @Inject(method={"<init>"}, at={@At(value="RETURN")})
        private void checkFullStatus(CallbackInfo ci) {
            boolean notWriter = false;
            for (VertexConsumer delegate : this.f_167071_) {
                if (VertexBufferWriter.tryOf(delegate) != null) continue;
                notWriter = true;
                break;
            }
            this.isFullWriter = !notWriter;
        }

        @Override
        public boolean canUseIntrinsics() {
            return this.isFullWriter;
        }

        @Override
        public void push(MemoryStack stack, long ptr, int count, VertexFormatDescription format) {
            for (VertexConsumer delegate : this.f_167071_) {
                VertexBufferWriter.copyInto(VertexBufferWriter.of(delegate), stack, ptr, count, format);
            }
        }
    }

    @Mixin(targets={"com/mojang/blaze3d/vertex/VertexMultiConsumer$Double"})
    public static class DualMixin
    implements VertexBufferWriter {
        @Shadow
        @Final
        private VertexConsumer f_86171_;
        @Shadow
        @Final
        private VertexConsumer f_86172_;
        private boolean isFullWriter;

        @Inject(method={"<init>"}, at={@At(value="RETURN")})
        private void checkFullStatus(CallbackInfo ci) {
            this.isFullWriter = VertexBufferWriter.tryOf(this.f_86171_) != null && VertexBufferWriter.tryOf(this.f_86172_) != null;
        }

        @Override
        public boolean canUseIntrinsics() {
            return this.isFullWriter;
        }

        @Override
        public void push(MemoryStack stack, long ptr, int count, VertexFormatDescription format) {
            VertexBufferWriter.copyInto(VertexBufferWriter.of(this.f_86171_), stack, ptr, count, format);
            VertexBufferWriter.copyInto(VertexBufferWriter.of(this.f_86172_), stack, ptr, count, format);
        }
    }
}

