/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.api.eventbus;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.common.MinecraftForge;
import org.embeddedt.embeddium.api.eventbus.EmbeddiumEvent;

public class EventHandlerRegistrar<T extends EmbeddiumEvent> {
    private final List<Handler<T>> handlerList = new CopyOnWriteArrayList<Handler<T>>();

    public void addListener(Handler<T> listener) {
        this.handlerList.add(listener);
    }

    public boolean post(T event) {
        boolean canceled = false;
        if (!this.handlerList.isEmpty()) {
            boolean isCancelable = ((EmbeddiumEvent)((Object)event)).isCancelable();
            for (Handler<T> handler : this.handlerList) {
                handler.acceptEvent(event);
                if (!isCancelable || !((EmbeddiumEvent)((Object)event)).isCanceled()) continue;
                canceled = true;
            }
        }
        return canceled |= EventHandlerRegistrar.postPlatformSpecificEvent(event);
    }

    private static <T extends EmbeddiumEvent> boolean postPlatformSpecificEvent(T event) {
        return MinecraftForge.EVENT_BUS.post(event);
    }

    @FunctionalInterface
    public static interface Handler<T extends EmbeddiumEvent> {
        public void acceptEvent(T var1);
    }
}

