/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.internal.util.PointerWrapper;

@NonnullDefault
public interface Buffer {
    public void delete();

    public int size();

    default public Allocation alloc(int size) {
        return this.alloc(size, 1);
    }

    public Allocation alloc(int var1, int var2);

    default public Allocation realloc(@Nullable Allocation allocation, int newSize, boolean copyData) {
        return this.realloc(allocation, newSize, 1, copyData);
    }

    public Allocation realloc(@Nullable Allocation var1, int var2, int var3, boolean var4);

    public void free(Allocation var1);

    public void dirtyAll();

    public CallbackHandle addReallocCallback(boolean var1, Consumer<Buffer> var2);

    default public <T extends Buffer> T as(Class<T> ignored) {
        return (T)this;
    }

    public static interface Allocation {
        public PointerWrapper address();

        public int offset();

        public int size();

        default public void dirty() {
            this.dirtyRange(0, this.size());
        }

        public void dirtyRange(int var1, int var2);

        public Buffer allocator();

        public void copy(int var1, int var2, int var3);

        public CallbackHandle addReallocCallback(Consumer<Allocation> var1);

        default public void free() {
            this.allocator().free(this);
        }
    }

    @FunctionalInterface
    public static interface CallbackHandle {
        public void delete();
    }
}

