/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.roguelogix.phosphophyllite.registry.ClientOnly;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.threading.WorkQueue;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.Quartz;
import net.roguelogix.quartz.QuartzConfig;
import net.roguelogix.quartz.QuartzEvent;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.EventListener;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl33.GL33Core;
import net.roguelogix.quartz.internal.gl46.GL46Core;
import net.roguelogix.quartz.internal.vk.VKCore;
import net.roguelogix.quartz.internal.world.WorldEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

@ClientOnly
@NonnullDefault
public abstract class QuartzCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"Quartz");
    public static final boolean DEBUG;
    @Nonnull
    public static final QuartzCore INSTANCE;
    public static final Cleaner CLEANER;
    public static final WorkQueue deletionQueue;
    private static boolean wasInit;
    private static final ReferenceSet<ResourceLocation> modelsToRegister;
    @Nullable
    public DrawBatch entityBatch = null;
    public final WorldEngine worldEngine = new WorldEngine();
    public final InternalMesh.Manager meshManager = new InternalMesh.Manager(this.allocBuffer(false));

    public static void mainThreadClean(Object referent, Runnable cleanFunc) {
        CLEANER.register(referent, () -> deletionQueue.enqueueUntracked(cleanFunc));
    }

    @Nullable
    private static QuartzCore createCore(QuartzConfig.Mode mode) {
        return switch (mode) {
            case QuartzConfig.Mode.Vulkan10 -> VKCore.INSTANCE;
            case QuartzConfig.Mode.OpenGL46 -> GL46Core.INSTANCE;
            case QuartzConfig.Mode.OpenGL33 -> GL33Core.INSTANCE;
            case QuartzConfig.Mode.Automatic -> {
                for (QuartzConfig.Mode value : QuartzConfig.Mode.values()) {
                    if (value == QuartzConfig.Mode.Automatic) {
                        yield null;
                    }
                    QuartzCore core = QuartzCore.createCore(value);
                    if (core == null) continue;
                    yield core;
                }
                yield null;
            }
            default -> null;
        };
    }

    static void init() {
    }

    static void startup() {
        INSTANCE.startupInternal();
        Quartz.EVENT_BUS.post((Event)new QuartzEvent.Startup());
        wasInit = true;
        MinecraftForge.EVENT_BUS.addListener(QuartzCore::addDebugTextEvent);
    }

    private static void addDebugTextEvent(CustomizeGuiOverlayEvent.DebugText debugTextEvent) {
        if (!Minecraft.m_91087_().f_91066_.f_92063_) {
            return;
        }
        ArrayList list = debugTextEvent.getRight();
        list.add("");
        INSTANCE.addDebugText(list);
        list.add("");
    }

    public static void registerModel(ResourceLocation modelLocation) {
        modelsToRegister.add((Object)modelLocation);
    }

    public static void onModelRegisterEvent(ModelEvent.RegisterAdditional event) {
        modelsToRegister.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @OnModLoad
    private static void onModLoad() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(QuartzCore::onModelRegisterEvent);
    }

    protected abstract void startupInternal();

    public static void shutdown() {
        if (!wasInit) {
            return;
        }
        QuartzCore.INSTANCE.entityBatch = null;
        Quartz.EVENT_BUS.post((Event)new QuartzEvent.Shutdown());
        INSTANCE.shutdownInternal();
        do {
            System.gc();
        } while (deletionQueue.runAll());
        System.gc();
    }

    protected abstract void shutdownInternal();

    public static void resourcesReloaded() {
        if (!wasInit) {
            return;
        }
        QuartzCore.INSTANCE.meshManager.buildAllMeshes();
        INSTANCE.resourcesReloadedInternal();
    }

    protected abstract void resourcesReloadedInternal();

    public WorldEngine getWorldEngine() {
        return this.worldEngine;
    }

    public abstract DrawBatch createDrawBatch();

    public DrawBatch getEntityBatcher() {
        if (this.entityBatch == null) {
            this.entityBatch = this.createDrawBatch();
        }
        return this.entityBatch;
    }

    public abstract Buffer allocBuffer(boolean var1);

    public abstract void frameStart(PoseStack var1, float var2, long var3, boolean var5, Camera var6, GameRenderer var7, LightTexture var8, Matrix4f var9);

    public abstract void lightUpdated();

    public abstract void preTerrainSetup();

    public abstract void shadowPass(PoseStack var1, Matrix4f var2);

    public abstract void preOpaque();

    public abstract void endOpaque();

    public abstract void endTranslucent();

    public abstract void waitIdle();

    public abstract int frameInFlight();

    public abstract void sectionDirty(int var1, int var2, int var3);

    public abstract void addDebugText(List<String> var1);

    static {
        CLEANER = Cleaner.create();
        deletionQueue = new WorkQueue();
        if (!Thread.currentThread().getStackTrace()[2].getClassName().equals(EventListener.class.getName())) {
            throw new IllegalStateException("Attempt to init quartz before it is ready");
        }
        LOGGER.info("Quartz Init");
        if (QuartzConfig.INSTANCE.debug) {
            LOGGER.warn("Debug mode enabled, performance may suffer");
        }
        DEBUG = QuartzConfig.INSTANCE.debug;
        QuartzCore instance = null;
        try {
            instance = QuartzCore.createCore(QuartzConfig.INSTANCE.mode);
            if (instance == null && QuartzConfig.INSTANCE.mode != QuartzConfig.Mode.Automatic) {
                LOGGER.error("Failed to create QuartzCore of requested type, attempting automatic creation");
                instance = QuartzCore.createCore(QuartzConfig.Mode.Automatic);
            }
            if (instance == null) {
                throw new IllegalStateException("QuartzCore failed to load, this shouldn't be possible");
            }
        }
        catch (NoClassDefFoundError e) {
            if (!e.getMessage().contains("phosphophyllite")) {
                throw e;
            }
            e.printStackTrace();
        }
        INSTANCE = instance;
        wasInit = false;
        modelsToRegister = new ReferenceArraySet();
    }
}

