/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33.batching;

import net.minecraft.client.renderer.RenderType;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl33.GL33FeedbackDrawing;
import net.roguelogix.quartz.internal.gl33.batching.GL33InstanceManager;
import net.roguelogix.quartz.internal.util.VertexFormatOutput;
import org.lwjgl.opengl.GL33C;

public class GL33DrawChunk {
    final GL33InstanceManager manager;
    final RenderType renderType;
    private final VertexFormatOutput outputFormat;
    public final int baseVertex;
    public final int vertexCount;
    int drawIndex;
    int[] VAO = new int[1];

    GL33DrawChunk(GL33InstanceManager manager, RenderType renderType, InternalMesh.Manager.TrackedMesh.Component component) {
        this.manager = manager;
        this.renderType = renderType;
        this.outputFormat = VertexFormatOutput.of(renderType.m_110508_());
        this.baseVertex = component.vertexOffset();
        this.vertexCount = component.vertexCount();
        this.rebuildVAO(manager.instanceDataAlloc.offset());
        int[] VAOAry = this.VAO;
        QuartzCore.mainThreadClean(this, () -> GL33C.glDeleteVertexArrays((int)VAOAry[0]));
    }

    void rebuildVAO(int offset) {
        GL33C.glDeleteVertexArrays((int)this.VAO[0]);
        this.VAO[0] = GL33C.glGenVertexArrays();
        B3DStateHelper.bindVertexArray(this.VAO[0]);
        GL33FeedbackDrawing.setupVAO(this.manager.drawBatch.intermediateInstanceDataBuffer.handle(), offset);
        B3DStateHelper.bindVertexArray(0);
    }

    void draw() {
        B3DStateHelper.bindVertexArray(this.VAO[0]);
        GL33C.glDrawArraysInstanced((int)0, (int)this.baseVertex, (int)this.vertexCount, (int)this.manager.instanceCount());
    }
}

