/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kir.smartrecipes.api.ContextualRecipeCondition;
import dev.kir.smartrecipes.api.RecipeConditions;
import dev.kir.smartrecipes.api.RecipeInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface RecipeCondition {
    public static final RecipeCondition FALSE = RecipeCondition.register("false", RecipeConditions.FALSE);
    public static final RecipeCondition TRUE = RecipeCondition.register("true", RecipeConditions.TRUE);
    public static final RecipeCondition COMMENT = RecipeCondition.register("comment", RecipeConditions.COMMENT);
    public static final RecipeCondition _COMMENT = RecipeCondition.register("_comment", RecipeConditions._COMMENT);
    public static final RecipeCondition OR = RecipeCondition.register("or", RecipeConditions.OR);
    public static final RecipeCondition AND = RecipeCondition.register("and", RecipeConditions.AND);
    public static final RecipeCondition NOT = RecipeCondition.register("not", RecipeConditions.NOT);
    public static final RecipeCondition ANY = RecipeCondition.register("any", RecipeConditions.ANY);
    public static final RecipeCondition ALL = RecipeCondition.register("all", RecipeConditions.ALL);
    public static final RecipeCondition NONE = RecipeCondition.register("none", RecipeConditions.NONE);
    public static final ContextualRecipeCondition IS_HARDCORE = RecipeCondition.register("is_hardcore", RecipeConditions.IS_HARDCORE);
    public static final ContextualRecipeCondition DIFFICULTY_CHECK = RecipeCondition.register("difficulty_check", RecipeConditions.DIFFICULTY_CHECK);
    public static final ContextualRecipeCondition IS_PEACEFUL_DIFFICULTY = RecipeCondition.register("is_peaceful_difficulty", RecipeConditions.IS_PEACEFUL_DIFFICULTY);
    public static final ContextualRecipeCondition IS_EASY_DIFFICULTY = RecipeCondition.register("is_easy_difficulty", RecipeConditions.IS_EASY_DIFFICULTY);
    public static final ContextualRecipeCondition IS_NORMAL_DIFFICULTY = RecipeCondition.register("is_normal_difficulty", RecipeConditions.IS_NORMAL_DIFFICULTY);
    public static final ContextualRecipeCondition IS_HARD_DIFFICULTY = RecipeCondition.register("is_hard_difficulty", RecipeConditions.IS_HARD_DIFFICULTY);
    public static final ContextualRecipeCondition GAMEMODE_CHECK = RecipeCondition.register("gamemode_check", RecipeConditions.GAMEMODE_CHECK);
    public static final ContextualRecipeCondition IS_SURVIVAL = RecipeCondition.register("is_survival", RecipeConditions.IS_SURVIVAL);
    public static final ContextualRecipeCondition IS_CREATIVE = RecipeCondition.register("is_creative", RecipeConditions.IS_CREATIVE);
    public static final ContextualRecipeCondition IS_ADVENTURE = RecipeCondition.register("is_adventure", RecipeConditions.IS_ADVENTURE);
    public static final ContextualRecipeCondition IS_SPECTATOR = RecipeCondition.register("is_spectator", RecipeConditions.IS_SPECTATOR);
    public static final ContextualRecipeCondition WEATHER_CHECK = RecipeCondition.register("weather_check", RecipeConditions.WEATHER_CHECK);
    public static final ContextualRecipeCondition TIME_CHECK = RecipeCondition.register("time_check", RecipeConditions.TIME_CHECK);
    public static final ContextualRecipeCondition PLAYERS_ONLINE = RecipeCondition.register("players_online", RecipeConditions.PLAYERS_ONLINE);
    public static final RecipeCondition ENTRIES_REGISTERED = RecipeCondition.register("entries_registered", RecipeConditions.ENTRIES_REGISTERED);
    public static final RecipeCondition BLOCKS_REGISTERED = RecipeCondition.register("blocks_registered", RecipeConditions.BLOCKS_REGISTERED);
    public static final RecipeCondition ITEMS_REGISTERED = RecipeCondition.register("items_registered", RecipeConditions.ITEMS_REGISTERED);
    public static final RecipeCondition BLOCK_ENTITIES_REGISTERED = RecipeCondition.register("block_entities_registered", RecipeConditions.BLOCK_ENTITIES_REGISTERED);
    public static final RecipeCondition MODS_LOADED = RecipeCondition.register("fabric:mods_loaded", RecipeConditions.MODS_LOADED);

    default public ResourceLocation getId() {
        return RecipeConditions.REGISTRY.m_7981_((Object)this);
    }

    default public boolean testConditionBody(JsonObject conditionBody, RecipeInfo info) {
        if (conditionBody == null) {
            throw new IllegalArgumentException("'conditionBody' cannot be null");
        }
        return this.test(conditionBody.get("args"), info);
    }

    public boolean test(@Nullable JsonElement var1, RecipeInfo var2);

    public static boolean isConditionBody(JsonElement jsonElement) {
        JsonObject jsonObject;
        return jsonElement instanceof JsonObject && GsonHelper.m_13813_((JsonObject)(jsonObject = (JsonObject)jsonElement), (String)"condition");
    }

    public static boolean test(JsonObject conditionBody, RecipeInfo info) {
        if (conditionBody == null) {
            throw new IllegalArgumentException("'conditionBody' cannot be null");
        }
        String id = GsonHelper.m_13906_((JsonObject)conditionBody, (String)"condition");
        RecipeCondition condition = RecipeCondition.get(id);
        if (condition == null) {
            throw new IllegalArgumentException("Unknown condition " + id);
        }
        return condition.testConditionBody(conditionBody, info);
    }

    public static boolean test(String id, @Nullable JsonElement args, RecipeInfo info) {
        return RecipeCondition.test(new ResourceLocation(id), args, info);
    }

    public static boolean test(ResourceLocation id, @Nullable JsonElement args, RecipeInfo info) {
        RecipeCondition condition = RecipeCondition.get(id);
        if (condition == null) {
            throw new IllegalArgumentException("Unknown condition " + id);
        }
        return condition.test(args, info);
    }

    @Nullable
    public static RecipeCondition get(String id) {
        return RecipeCondition.get(new ResourceLocation(id));
    }

    @Nullable
    public static RecipeCondition get(ResourceLocation id) {
        return (RecipeCondition)RecipeConditions.REGISTRY.m_7745_(id);
    }

    public static <T extends RecipeCondition> T register(String id, T condition) {
        return RecipeCondition.register(new ResourceLocation(id), condition);
    }

    public static <T extends RecipeCondition> T register(ResourceLocation id, T condition) {
        return (T)((RecipeCondition)Registry.m_122965_(RecipeConditions.REGISTRY, (ResourceLocation)id, condition));
    }
}

