/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Lifecycle;
import dev.kir.smartrecipes.SmartRecipes;
import dev.kir.smartrecipes.api.ContextualRecipeCondition;
import dev.kir.smartrecipes.api.ModEntry;
import dev.kir.smartrecipes.api.RecipeCondition;
import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.RegistryEntry;
import dev.kir.smartrecipes.util.JsonUtil;
import dev.kir.smartrecipes.util.world.TimeOfDay;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelData;

final class RecipeConditions {
    public static final ResourceKey<Registry<RecipeCondition>> KEY = ResourceKey.m_135788_((ResourceLocation)SmartRecipes.locate("recipe_condition"));
    public static final Registry<RecipeCondition> REGISTRY = new MappedRegistry(KEY, Lifecycle.experimental());
    public static final RecipeCondition FALSE = (e, i) -> false;
    public static final RecipeCondition TRUE = (e, i) -> true;
    public static final RecipeCondition COMMENT = (e, i) -> true;
    public static final RecipeCondition _COMMENT = (e, i) -> false;
    public static final RecipeCondition OR = (e, i) -> {
        Iterator iterator = RecipeConditions.test(e, i).iterator();
        if (!iterator.hasNext()) {
            throw new JsonSyntaxException("The OR operator requires at least one argument. Consider using ANY instead.");
        }
        do {
            if (!((Boolean)iterator.next()).booleanValue()) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    };
    public static final RecipeCondition AND = (e, i) -> {
        Iterator iterator = RecipeConditions.test(e, i).iterator();
        if (!iterator.hasNext()) {
            throw new JsonSyntaxException("The AND operator requires at least one argument. Consider using ALL instead.");
        }
        do {
            if (((Boolean)iterator.next()).booleanValue()) continue;
            return false;
        } while (iterator.hasNext());
        return true;
    };
    public static final RecipeCondition NOT = (e, i) -> {
        Iterator iterator = RecipeConditions.test(e, i).iterator();
        if (!iterator.hasNext()) {
            throw new JsonSyntaxException("The NOT operator requires at least one argument. Consider using NONE instead.");
        }
        do {
            if (!((Boolean)iterator.next()).booleanValue()) continue;
            return false;
        } while (iterator.hasNext());
        return true;
    };
    public static final RecipeCondition ANY = (e, i) -> RecipeConditions.test(e, i).anyMatch(x -> x);
    public static final RecipeCondition ALL = (e, i) -> RecipeConditions.test(e, i).allMatch(x -> x);
    public static final RecipeCondition NONE = (e, i) -> RecipeConditions.test(e, i).noneMatch(x -> x);
    public static final ContextualRecipeCondition IS_HARDCORE = (e, ctx) -> ctx.getServer().m_7035_();
    public static final ContextualRecipeCondition DIFFICULTY_CHECK = (e, ctx) -> JsonUtil.flatMap(e).map(RecipeConditions::parseDifficulty).anyMatch(arg_0 -> ctx.getServer().m_129910_().m_5472_().equals(arg_0));
    public static final ContextualRecipeCondition IS_PEACEFUL_DIFFICULTY = (e, ctx) -> Difficulty.PEACEFUL.equals((Object)ctx.getServer().m_129910_().m_5472_());
    public static final ContextualRecipeCondition IS_EASY_DIFFICULTY = (e, ctx) -> Difficulty.EASY.equals((Object)ctx.getServer().m_129910_().m_5472_());
    public static final ContextualRecipeCondition IS_NORMAL_DIFFICULTY = (e, ctx) -> Difficulty.NORMAL.equals((Object)ctx.getServer().m_129910_().m_5472_());
    public static final ContextualRecipeCondition IS_HARD_DIFFICULTY = (e, ctx) -> Difficulty.HARD.equals((Object)ctx.getServer().m_129910_().m_5472_());
    public static final ContextualRecipeCondition GAMEMODE_CHECK = (e, ctx) -> JsonUtil.flatMap(e).map(RecipeConditions::parseGameMode).anyMatch(arg_0 -> ctx.getServer().m_130008_().equals(arg_0));
    public static final ContextualRecipeCondition IS_SURVIVAL = (e, ctx) -> GameType.SURVIVAL.equals((Object)ctx.getServer().m_130008_());
    public static final ContextualRecipeCondition IS_CREATIVE = (e, ctx) -> GameType.CREATIVE.equals((Object)ctx.getServer().m_130008_());
    public static final ContextualRecipeCondition IS_ADVENTURE = (e, ctx) -> GameType.ADVENTURE.equals((Object)ctx.getServer().m_130008_());
    public static final ContextualRecipeCondition IS_SPECTATOR = (e, ctx) -> GameType.SPECTATOR.equals((Object)ctx.getServer().m_130008_());
    public static final ContextualRecipeCondition WEATHER_CHECK = (e, ctx) -> {
        boolean clear = false;
        boolean rain = false;
        boolean thunder = false;
        for (String weatherId : JsonUtil.flatMap(e).map(JsonPrimitive::getAsString)::iterator) {
            if ((weatherId = weatherId.toLowerCase()).startsWith("clea")) {
                clear = true;
                continue;
            }
            if (weatherId.startsWith("rain")) {
                rain = true;
                continue;
            }
            if (!weatherId.startsWith("thunder")) continue;
            thunder = true;
        }
        LevelData worldProperties = ctx.getServer().m_129783_().m_6106_();
        return clear && !worldProperties.m_6533_() || rain && worldProperties.m_6533_() || thunder && worldProperties.m_6534_();
    };
    public static final ContextualRecipeCondition TIME_CHECK = (e, ctx) -> {
        TimeOfDay time = TimeOfDay.fromTime(ctx.getServer().m_129783_().m_46468_());
        return JsonUtil.flatMap(e).map(RecipeConditions::parseTimeOfDay).anyMatch(x -> x.contains(time));
    };
    public static final ContextualRecipeCondition PLAYERS_ONLINE = (e, ctx) -> {
        List<String> names = Arrays.asList(ctx.getServer().m_7641_());
        return JsonUtil.flatMap(e).allMatch(x -> names.contains(x.getAsString()));
    };
    public static final RecipeCondition ENTRIES_REGISTERED = (e, i) -> JsonUtil.flatMap(e, RegistryEntry::parse, RegistryEntry::parse).allMatch(x -> {
        Registry registry = (Registry)BuiltInRegistries.f_257047_.m_7745_(new ResourceLocation(x.registry()));
        return registry != null && registry.m_7804_(new ResourceLocation(x.entry()));
    });
    public static final RecipeCondition BLOCKS_REGISTERED = (e, i) -> JsonUtil.flatMap(e).allMatch(x -> BuiltInRegistries.f_256975_.m_7804_(new ResourceLocation(x.getAsString())));
    public static final RecipeCondition ITEMS_REGISTERED = (e, i) -> JsonUtil.flatMap(e).allMatch(x -> BuiltInRegistries.f_257033_.m_7804_(new ResourceLocation(x.getAsString())));
    public static final RecipeCondition BLOCK_ENTITIES_REGISTERED = (e, i) -> JsonUtil.flatMap(e).allMatch(x -> BuiltInRegistries.f_257049_.m_7804_(new ResourceLocation(x.getAsString())));
    public static final RecipeCondition MODS_LOADED = (e, i) -> JsonUtil.flatMap(e, ModEntry::parse, ModEntry::parse).allMatch(x -> {
        ModContainer mod = FabricLoader.getInstance().getModContainer(x.id()).orElse(null);
        if (mod == null) {
            return false;
        }
        try {
            return VersionPredicate.parse((String)x.version()).test((Object)mod.getMetadata().getVersion());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    });

    RecipeConditions() {
    }

    private static Stream<Boolean> test(JsonElement element, RecipeInfo info) {
        JsonPrimitive primitive;
        if (RecipeCondition.isConditionBody(element)) {
            return Stream.of(Boolean.valueOf(RecipeCondition.test((JsonObject)element, info)));
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            return jsonObject.entrySet().stream().map(entry -> RecipeCondition.test((String)entry.getKey(), (JsonElement)entry.getValue(), info));
        }
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            return StreamSupport.stream(jsonArray.spliterator(), false).flatMap(e -> RecipeConditions.test(e, info));
        }
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
            return Stream.of(Boolean.valueOf(RecipeCondition.test(primitive.getAsString(), null, info)));
        }
        return Stream.of(Boolean.valueOf(JsonUtil.asBoolean(element)));
    }

    private static Difficulty parseDifficulty(JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() ? Difficulty.m_19029_((int)jsonPrimitive.getAsInt()) : Difficulty.m_19031_((String)jsonPrimitive.getAsString().toLowerCase());
    }

    private static GameType parseGameMode(JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() ? GameType.m_46393_((int)jsonPrimitive.getAsInt()) : GameType.m_46400_((String)jsonPrimitive.getAsString().toLowerCase());
    }

    private static TimeOfDay parseTimeOfDay(JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() ? TimeOfDay.fromTime(jsonPrimitive.getAsLong()) : TimeOfDay.byName(jsonPrimitive.getAsString().toLowerCase());
    }
}

