/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api;

import com.google.gson.JsonObject;
import dev.kir.smartrecipes.api.RecipeInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Contract;

public class RecipeContext
extends RecipeInfo {
    private final MinecraftServer server;
    private final ResourceManager resourceManager;
    private final ProfilerFiller profiler;

    public RecipeContext(MinecraftServer server, ResourceManager resourceManager, ProfilerFiller profiler) {
        this(null, null, server, resourceManager, profiler);
    }

    public RecipeContext(ResourceLocation recipeId, JsonObject recipeObject, MinecraftServer server, ResourceManager resourceManager, ProfilerFiller profiler) {
        super(recipeId, recipeObject);
        this.server = server;
        this.resourceManager = resourceManager;
        this.profiler = profiler;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ProfilerFiller getProfiler() {
        return this.profiler;
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public RecipeContext with(ResourceLocation recipeId, JsonObject recipeObject) {
        return new RecipeContext(recipeId, recipeObject, this.server, this.resourceManager, this.profiler);
    }
}

