/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Contract;

public class RecipeInfo {
    private final ResourceLocation recipeId;
    private final JsonObject recipeObject;
    private Recipe<?> recipe;
    private RecipeType<?> recipeType;

    public RecipeInfo(ResourceLocation recipeId, JsonObject recipeObject) {
        this.recipeId = recipeId;
        this.recipeObject = recipeObject;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public JsonObject getRecipeAsJson() {
        return this.recipeObject;
    }

    public Optional<RecipeType<?>> getRecipeType() {
        if (this.recipe != null) {
            return Optional.of(this.recipe.m_6671_());
        }
        if (this.recipeType == null && this.recipeObject != null) {
            ResourceLocation id;
            JsonPrimitive typePrimitive;
            JsonElement jsonElement = this.recipeObject.get("type");
            String type = jsonElement instanceof JsonPrimitive && (typePrimitive = (JsonPrimitive)jsonElement).isString() ? typePrimitive.getAsString() : null;
            ResourceLocation resourceLocation = id = type == null ? null : ResourceLocation.m_135820_(type);
            if (id != null) {
                this.recipeType = BuiltInRegistries.f_256990_.m_6612_(id).or(() -> BuiltInRegistries.f_256990_.m_6612_(new ResourceLocation(id.m_135827_(), id.m_135815_().split("_")[0]))).orElse(null);
            }
        }
        return Optional.ofNullable(this.recipeType);
    }

    public Optional<Recipe<?>> getRecipe() {
        if (this.recipe == null && this.recipeId != null && this.recipeObject != null) {
            try {
                this.recipe = RecipeManager.m_44045_((ResourceLocation)this.recipeId, (JsonObject)this.recipeObject);
            }
            catch (Throwable e) {
                this.recipe = null;
            }
        }
        return Optional.ofNullable(this.recipe);
    }

    @Contract(value="_, _ -> new", pure=true)
    public RecipeInfo with(ResourceLocation recipeId, JsonObject recipeObject) {
        return new RecipeInfo(recipeId, recipeObject);
    }
}

