/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api;

import dev.kir.smartrecipes.api.RecipeReloadConditions;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface RecipeReloadCondition {
    public static final RecipeReloadCondition END_DATA_PACK_RELOAD = RecipeReloadCondition.register("end_data_pack_reload", RecipeReloadConditions.END_DATA_PACK_RELOAD);
    public static final RecipeReloadCondition PLAYER_JOINED = RecipeReloadCondition.register("player_joined", RecipeReloadConditions.PLAYER_JOINED);
    public static final RecipeReloadCondition PLAYER_DISCONNECTED = RecipeReloadCondition.register("player_disconnected", RecipeReloadConditions.PLAYER_DISCONNECTED);
    public static final RecipeReloadCondition DIFFICULTY_CHANGED = RecipeReloadCondition.register("difficulty_changed", RecipeReloadConditions.DIFFICULTY_CHANGED);
    public static final RecipeReloadCondition GAMEMODE_CHANGED = RecipeReloadCondition.register("gamemode_changed", RecipeReloadConditions.GAMEMODE_CHANGED);
    public static final RecipeReloadCondition WEATHER_CHANGED = RecipeReloadCondition.register("weather_changed", RecipeReloadConditions.WEATHER_CHANGED);
    public static final RecipeReloadCondition TIME_CHANGED = RecipeReloadCondition.register("time_changed", RecipeReloadConditions.TIME_CHANGED);

    default public ResourceLocation getId() {
        return RecipeReloadConditions.REGISTRY.m_7981_((Object)this);
    }

    public RecipeReloadConditionListener invoker();

    public void register(RecipeReloadConditionListener var1);

    @Nullable
    public static RecipeReloadCondition get(String id) {
        return RecipeReloadCondition.get(new ResourceLocation(id));
    }

    @Nullable
    public static RecipeReloadCondition get(ResourceLocation id) {
        return (RecipeReloadCondition)RecipeReloadConditions.REGISTRY.m_7745_(id);
    }

    public static <T extends RecipeReloadCondition> T register(String id, T condition) {
        return RecipeReloadCondition.register(new ResourceLocation(id), condition);
    }

    public static <T extends RecipeReloadCondition> T register(ResourceLocation id, T condition) {
        condition = (RecipeReloadCondition)Registry.m_122965_(RecipeReloadConditions.REGISTRY, (ResourceLocation)id, condition);
        condition.register((server, cause) -> ((ReloadableRecipeManager)server.m_129894_()).reload(server, cause));
        return (T)condition;
    }

    @FunctionalInterface
    public static interface RecipeReloadConditionListener {
        public void onRecipeReloadEvent(MinecraftServer var1, ResourceLocation var2);
    }
}

