/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;

public final class ServerStateEvents {
    public static final Event<DifficultyChanged> DIFFICULTY_CHANGED = EventFactory.createArrayBacked(DifficultyChanged.class, callbacks -> (server, oldDifficulty, newDifficulty) -> {
        for (DifficultyChanged callback : callbacks) {
            callback.onDifficultyChanged(server, oldDifficulty, newDifficulty);
        }
    });
    public static final Event<GameModeChanged> GAMEMODE_CHANGED = EventFactory.createArrayBacked(GameModeChanged.class, callbacks -> (server, oldGameMode, newGameMode) -> {
        for (GameModeChanged callback : callbacks) {
            callback.onGameModeChanged(server, oldGameMode, newGameMode);
        }
    });

    private ServerStateEvents() {
    }

    @FunctionalInterface
    public static interface GameModeChanged {
        public void onGameModeChanged(MinecraftServer var1, GameType var2, GameType var3);
    }

    @FunctionalInterface
    public static interface DifficultyChanged {
        public void onDifficultyChanged(MinecraftServer var1, Difficulty var2, Difficulty var3);
    }
}

