/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api.networking;

import com.google.gson.JsonObject;
import dev.kir.smartrecipes.SmartRecipes;
import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import dev.kir.smartrecipes.util.recipe.RecipeBookUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class SynchronizeReloadedRecipesPacket {
    public static final ResourceLocation ID = SmartRecipes.locate("packet.sync.recipes");
    private final Collection<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> reloadedRecipes;

    public SynchronizeReloadedRecipesPacket(Collection<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> reloadedRecipes) {
        this.reloadedRecipes = reloadedRecipes;
    }

    public SynchronizeReloadedRecipesPacket(FriendlyByteBuf buf) {
        this.reloadedRecipes = buf.m_236845_(SynchronizeReloadedRecipesPacket::readRecipeEntry);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236828_(this.reloadedRecipes, SynchronizeReloadedRecipesPacket::writeRecipeEntry);
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(Minecraft client, ClientPacketListener handler) {
        ClientRecipeBook recipeBook;
        RecipeManager recipeManager = handler.m_105141_();
        ((ReloadableRecipeManager)recipeManager).apply(this.reloadedRecipes);
        ClientRecipeBook clientRecipeBook = recipeBook = client.f_91074_ == null ? null : client.f_91074_.m_108631_();
        if (recipeBook != null) {
            RecipeBookUtil.apply((RecipeBook)recipeBook, handler.m_105152_(), this.reloadedRecipes);
        }
    }

    public void send(Stream<ServerPlayer> players) {
        FriendlyByteBuf buffer = PacketByteBufs.create();
        this.write(buffer);
        players.forEach(player -> ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ID, (FriendlyByteBuf)buffer));
    }

    private static <T extends Recipe<?>> void writeRecipeEntry(FriendlyByteBuf buf, Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo> recipeEntry) {
        ReloadableRecipeManager.RecipeState state = (ReloadableRecipeManager.RecipeState)((Object)recipeEntry.m_14418_());
        RecipeInfo recipeInfo = (RecipeInfo)recipeEntry.m_14419_();
        if (state == ReloadableRecipeManager.RecipeState.KEEP) {
            Recipe<?> recipe = recipeInfo.getRecipe().orElseThrow(() -> new IllegalArgumentException("Unable to parse recipe '" + recipeInfo.getRecipeId() + "'"));
            buf.writeBoolean(true);
            buf.m_130085_(BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_()));
            buf.m_130085_(recipe.m_6423_());
            recipe.m_7707_().m_6178_(buf, recipe);
        } else {
            buf.writeBoolean(false);
            buf.m_130085_(recipeInfo.getRecipeId());
            buf.m_130085_(BuiltInRegistries.f_256990_.m_7981_(recipeInfo.getRecipeType().orElseThrow(() -> new IllegalArgumentException("Recipe '" + recipeInfo.getRecipeId() + "' uses invalid or unsupported recipe type"))));
        }
    }

    private static Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo> readRecipeEntry(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            ResourceLocation serializerId = buf.m_130281_();
            RecipeSerializer serializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_6612_(serializerId).orElseThrow(() -> new IllegalArgumentException("Unknown recipe serializer " + serializerId));
            ResourceLocation recipeId = buf.m_130281_();
            Recipe recipe = serializer.m_8005_(recipeId, buf);
            return new Tuple((Object)ReloadableRecipeManager.RecipeState.KEEP, (Object)new SerializableRecipeInfo(recipeId, recipe));
        }
        ResourceLocation recipeId = buf.m_130281_();
        ResourceLocation recipeTypeId = buf.m_130281_();
        RecipeType recipeType = (RecipeType)BuiltInRegistries.f_256990_.m_6612_(recipeTypeId).orElseThrow(() -> new IllegalArgumentException("Invalid or unsupported recipe type '" + recipeTypeId + "'"));
        return new Tuple((Object)ReloadableRecipeManager.RecipeState.REMOVE, (Object)new SerializableRecipeInfo(recipeId, recipeType));
    }

    private static class SerializableRecipeInfo
    extends RecipeInfo {
        private final Recipe<?> recipe;
        private final RecipeType<?> recipeType;

        public SerializableRecipeInfo(ResourceLocation recipeId, RecipeType<?> recipeType) {
            super(recipeId, null);
            this.recipe = null;
            this.recipeType = recipeType;
        }

        public SerializableRecipeInfo(ResourceLocation recipeId, Recipe<?> recipe) {
            super(recipeId, null);
            this.recipe = recipe;
            this.recipeType = null;
        }

        @Override
        public Optional<Recipe<?>> getRecipe() {
            return Optional.ofNullable(this.recipe);
        }

        @Override
        public Optional<RecipeType<?>> getRecipeType() {
            return this.recipeType == null ? this.getRecipe().map(Recipe::m_6671_) : Optional.of(this.recipeType);
        }

        @Override
        public JsonObject getRecipeAsJson() {
            throw new IllegalStateException("JSON is not available on the client side");
        }
    }
}

