/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.mixin;

import com.mojang.datafixers.DataFixer;
import dev.kir.smartrecipes.api.event.ServerStateEvents;
import java.net.Proxy;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class MinecraftServerMixin {
    @Final
    @Shadow
    protected WorldData f_129749_;
    @Unique
    private Difficulty difficulty;
    @Unique
    private GameType gameMode;

    MinecraftServerMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(Thread serverThread, LevelStorageSource.LevelStorageAccess session, PackRepository dataPackManager, WorldStem saveLoader, Proxy proxy, DataFixer dataFixer, Services apiServices, ChunkProgressListenerFactory worldGenerationProgressListenerFactory, CallbackInfo ci) {
        this.difficulty = this.f_129749_.m_5472_();
        this.gameMode = this.f_129749_.m_5464_();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        if (this.difficulty != this.f_129749_.m_5472_()) {
            ((ServerStateEvents.DifficultyChanged)ServerStateEvents.DIFFICULTY_CHANGED.invoker()).onDifficultyChanged(server, this.difficulty, this.f_129749_.m_5472_());
            this.difficulty = this.f_129749_.m_5472_();
        }
        if (this.gameMode != this.f_129749_.m_5464_()) {
            ((ServerStateEvents.GameModeChanged)ServerStateEvents.GAMEMODE_CHANGED.invoker()).onGameModeChanged(server, this.gameMode, this.f_129749_.m_5464_());
            this.gameMode = this.f_129749_.m_5464_();
        }
    }
}

