/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kir.smartrecipes.SmartRecipes;
import dev.kir.smartrecipes.api.RecipeCondition;
import dev.kir.smartrecipes.api.RecipeContext;
import dev.kir.smartrecipes.api.RecipeContextRequiredException;
import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.RecipeReloadCondition;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import dev.kir.smartrecipes.api.networking.SynchronizeReloadedRecipesPacket;
import dev.kir.smartrecipes.util.JsonUtil;
import dev.kir.smartrecipes.util.recipe.RecipeBookUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.Tuple;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
class RecipeManagerMixin
implements ReloadableRecipeManager {
    @Unique
    private static final ResourceLocation CONDITIONS = SmartRecipes.locate("conditions");
    @Unique
    private static final ResourceLocation OBSOLETE_CONDITIONS = new ResourceLocation("conditions");
    @Unique
    private static final ResourceLocation RELOAD_CONDITIONS = SmartRecipes.locate("reload_conditions");
    @Unique
    private static final ResourceLocation OBSOLETE_RELOAD_CONDITIONS = new ResourceLocation("reload_conditions");
    @Shadow
    private Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> f_44007_;
    @Unique
    private Map<ResourceLocation, Collection<Map.Entry<ResourceLocation, JsonElement>>> waitingForReload;

    RecipeManagerMixin() {
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)V"}, at={@At(value="HEAD")})
    private void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        this.waitingForReload = new ConcurrentHashMap<ResourceLocation, Collection<Map.Entry<ResourceLocation, JsonElement>>>();
        int skipped = 0;
        ResourceLocation defaultContextualConditionId = RecipeReloadCondition.END_DATA_PACK_RELOAD.getId();
        Iterator<Map.Entry<ResourceLocation, JsonElement>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, JsonElement> entry = iterator.next();
            if (!entry.getValue().isJsonObject()) continue;
            ResourceLocation recipeId = entry.getKey();
            JsonObject recipeObject = entry.getValue().getAsJsonObject();
            JsonElement conditions = JsonUtil.get(recipeObject, CONDITIONS);
            boolean isObsoleteEntry = false;
            if (conditions == null) {
                conditions = JsonUtil.get(recipeObject, OBSOLETE_CONDITIONS);
                isObsoleteEntry = true;
            }
            if (conditions == null) continue;
            Stream<Object> reloadConditions = Stream.empty();
            try {
                if (!RecipeCondition.ALL.test(conditions, new RecipeInfo(recipeId, recipeObject))) {
                    iterator.remove();
                    ++skipped;
                }
            }
            catch (RecipeContextRequiredException e) {
                reloadConditions = Stream.of(defaultContextualConditionId);
            }
            catch (Throwable e) {
                if (!isObsoleteEntry) {
                    RecipeManagerMixin.logParsingError(recipeId, e);
                }
                isObsoleteEntry = false;
            }
            JsonElement definedReloadConditions = JsonUtil.get(recipeObject, RELOAD_CONDITIONS);
            if (definedReloadConditions == null) {
                definedReloadConditions = JsonUtil.get(recipeObject, OBSOLETE_RELOAD_CONDITIONS);
                isObsoleteEntry |= definedReloadConditions != null;
            }
            reloadConditions = Stream.concat(reloadConditions, JsonUtil.flatMap(definedReloadConditions).map(x -> ResourceLocation.m_135820_((String)x.getAsString())).filter(Objects::nonNull));
            for (ResourceLocation reloadConditionId : reloadConditions::iterator) {
                this.waitingForReload.computeIfAbsent(reloadConditionId, i -> ConcurrentHashMap.newKeySet()).add(entry);
            }
            if (!isObsoleteEntry || !SmartRecipes.CONFIG.getValue("debug").orElse(true).booleanValue()) continue;
            SmartRecipes.LOGGER.warn("{} uses obsolete '{}' and/or '{}' entries. Consider using '{}' and '{}' instead.", (Object)recipeId, (Object)OBSOLETE_CONDITIONS, (Object)OBSOLETE_RELOAD_CONDITIONS, (Object)CONDITIONS, (Object)RELOAD_CONDITIONS);
        }
        SmartRecipes.LOGGER.info("Skipped {} recipes", (Object)skipped);
    }

    @Override
    public void reload(MinecraftServer server, ResourceLocation cause) {
        Collection<Map.Entry<ResourceLocation, JsonElement>> reloadableRecipes;
        Collection<Map.Entry<ResourceLocation, JsonElement>> collection = reloadableRecipes = this.waitingForReload == null ? null : this.waitingForReload.get(cause);
        if (server == null || reloadableRecipes == null || reloadableRecipes.size() == 0) {
            return;
        }
        int reloaded = 0;
        int removed = 0;
        int added = 0;
        ArrayList<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff = new ArrayList<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>>();
        RecipeContext recipeContext = new RecipeContext(server, server.m_177941_(), server.m_129905_());
        for (Map.Entry<ResourceLocation, JsonElement> entry : reloadableRecipes) {
            ResourceLocation recipeId = entry.getKey();
            try {
                boolean exists;
                boolean shouldExist;
                JsonObject recipeObject = entry.getValue().getAsJsonObject();
                RecipeContext recipeInfo = recipeContext.with(recipeId, recipeObject);
                JsonElement conditions = JsonUtil.get(recipeObject, CONDITIONS);
                if (conditions == null) {
                    conditions = JsonUtil.get(recipeObject, OBSOLETE_CONDITIONS);
                }
                if ((shouldExist = RecipeCondition.ALL.test(conditions, recipeInfo)) == (exists = this.f_44007_.get(recipeInfo.getRecipeType().orElseThrow()).containsKey(recipeId))) continue;
                diff.add((Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>)new Tuple((Object)(shouldExist ? ReloadableRecipeManager.RecipeState.KEEP : ReloadableRecipeManager.RecipeState.REMOVE), (Object)recipeInfo));
                ++reloaded;
                if (shouldExist) {
                    ++added;
                    continue;
                }
                ++removed;
            }
            catch (Throwable e) {
                RecipeManagerMixin.logParsingError(recipeId, e);
            }
        }
        if (reloaded != 0) {
            this.apply(diff);
            this.sync(server, diff);
            SmartRecipes.LOGGER.info("Reloaded {} recipes (removed: {} | added: {}) on the '{}' event", (Object)reloaded, (Object)removed, (Object)added, (Object)cause);
        }
    }

    @Override
    public void apply(Collection<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff) {
        if (diff.isEmpty()) {
            return;
        }
        Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> mutableRecipes = RecipeManagerMixin.makeMutable(this.f_44007_);
        for (Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo> entry : diff) {
            ReloadableRecipeManager.RecipeState recipeState = (ReloadableRecipeManager.RecipeState)((Object)entry.m_14418_());
            RecipeInfo recipeInfo = (RecipeInfo)entry.m_14419_();
            ResourceLocation recipeId = recipeInfo.getRecipeId();
            try {
                RecipeType<?> recipeType = recipeInfo.getRecipeType().orElseThrow(() -> new IllegalArgumentException("Recipe '" + recipeId + "' uses invalid or unsupported recipe type"));
                switch (recipeState) {
                    case KEEP: {
                        Map container = mutableRecipes.computeIfAbsent(recipeType, x -> new HashMap());
                        container.put(recipeId, recipeInfo.getRecipe().orElseThrow(() -> new IllegalArgumentException("Unable to parse recipe '" + recipeId + "'")));
                        break;
                    }
                    case REMOVE: {
                        Map container = mutableRecipes.get(recipeType);
                        if (container == null) break;
                        container.remove(recipeId);
                    }
                }
            }
            catch (Throwable e) {
                RecipeManagerMixin.logParsingError(recipeId, e);
            }
        }
        this.f_44007_ = mutableRecipes;
    }

    @Unique
    private void sync(MinecraftServer server, Collection<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff) {
        if (diff.isEmpty()) {
            return;
        }
        new SynchronizeReloadedRecipesPacket(diff).send(PlayerLookup.all((MinecraftServer)server).stream());
        PlayerLookup.all((MinecraftServer)server).forEach(x -> RecipeBookUtil.apply((RecipeBook)x.m_8952_(), (RegistryAccess)server.m_206579_(), diff));
    }

    @Unique
    private static void logParsingError(ResourceLocation recipeId, Throwable error) {
        if (SmartRecipes.CONFIG.getValue("debug").orElse(true).booleanValue()) {
            SmartRecipes.LOGGER.error("Parsing error loading recipe {}", (Object)recipeId, (Object)error);
        }
    }

    @Unique
    private static Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> makeMutable(Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> recipes) {
        if (recipes instanceof HashMap) {
            return recipes;
        }
        return recipes.entrySet().stream().map(x -> new AbstractMap.SimpleEntry((RecipeType)x.getKey(), new HashMap((Map)x.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

