/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.mixin;

import dev.kir.smartrecipes.api.event.WorldStateEvents;
import dev.kir.smartrecipes.util.world.TimeOfDay;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
abstract class ServerWorldMixin
extends Level {
    @Final
    @Shadow
    private ServerLevelData f_8549_;
    @Unique
    private boolean wasRaining;
    @Unique
    private boolean wasThundering;
    @Unique
    private TimeOfDay timeOfDay;

    protected ServerWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(MinecraftServer server, Executor workerExecutor, LevelStorageSource.LevelStorageAccess session, ServerLevelData properties, ResourceKey<?> worldKey, LevelStem dimensionOptions, ChunkProgressListener worldGenerationProgressListener, boolean debugWorld, long seed, List<?> spawners, boolean shouldTickTime, RandomSequences randomSequencesState, CallbackInfo ci) {
        this.wasRaining = properties.m_6533_();
        this.wasThundering = properties.m_6534_();
        this.timeOfDay = TimeOfDay.fromTime(properties.m_6792_());
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (this.wasRaining != this.f_8549_.m_6533_() || this.wasThundering != this.f_8549_.m_6534_()) {
            ((WorldStateEvents.WeatherChanged)WorldStateEvents.WEATHER_CHANGED.invoker()).onWeatherChanged((ServerLevel)this);
            this.wasRaining = this.f_8549_.m_6533_();
            this.wasThundering = this.f_8549_.m_6534_();
        }
    }

    @Inject(method={"setTimeOfDay"}, at={@At(value="RETURN")})
    private void setTimeOfDay(long time, CallbackInfo ci) {
        TimeOfDay newTimeOfDay = TimeOfDay.fromTime(time);
        if (this.timeOfDay != newTimeOfDay) {
            ((WorldStateEvents.TimeOfDayChanged)WorldStateEvents.TIME_CHANGED.invoker()).onTimeOfDayChanged((ServerLevel)this, this.timeOfDay, newTimeOfDay);
            this.timeOfDay = newTimeOfDay;
        }
    }
}

