/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;

public final class JsonUtil {
    public static boolean isNull(JsonElement jsonElement) {
        return jsonElement == null || jsonElement instanceof JsonNull;
    }

    public static JsonElement get(JsonObject jsonObject, ResourceLocation memberId) {
        JsonElement member = jsonObject.get(memberId.toString());
        return member == null && "minecraft".equals(memberId.m_135827_()) ? jsonObject.get(memberId.m_135815_()) : member;
    }

    public static Stream<JsonPrimitive> flatMap(JsonElement jsonElement) {
        return JsonUtil.flatMap(jsonElement, x -> x, x -> x.entrySet().stream().filter(entry -> JsonUtil.asBoolean((JsonElement)entry.getValue())).map(entry -> new JsonPrimitive((String)entry.getKey())));
    }

    public static <T> Stream<T> flatMap(JsonElement jsonElement, Function<JsonPrimitive, T> primitiveParser, Function<JsonObject, Stream<T>> objectParser) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            return Stream.of(primitiveParser.apply(jsonPrimitive));
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return objectParser.apply(jsonObject);
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            return StreamSupport.stream(jsonArray.spliterator(), false).flatMap(e -> JsonUtil.flatMap(e, primitiveParser, objectParser));
        }
        return Stream.empty();
    }

    public static boolean asBoolean(JsonElement jsonElement) {
        if (JsonUtil.isNull(jsonElement)) {
            return false;
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            return primitive.isBoolean() && primitive.getAsBoolean() || primitive.isString() && primitive.getAsString().length() != 0 || primitive.isNumber() && primitive.getAsDouble() != 0.0;
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return jsonObject.size() != 0;
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            return jsonArray.size() != 0;
        }
        return true;
    }
}

