/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.util.recipe;

import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.RecipeToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.Recipe;

public final class RecipeBookUtil {
    public static void apply(RecipeBook recipeBook, RegistryAccess registryManager, Collection<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff) {
        RecipeBookUtil.apply(recipeBook, registryManager, diff, false);
    }

    public static void apply(RecipeBook recipeBook, RegistryAccess registryManager, Collection<Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff, boolean showRecipeToasts) {
        if (diff.isEmpty()) {
            return;
        }
        boolean isClient = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        for (Tuple<ReloadableRecipeManager.RecipeState, RecipeInfo> entry : diff) {
            ReloadableRecipeManager.RecipeState recipeState = (ReloadableRecipeManager.RecipeState)((Object)entry.m_14418_());
            RecipeInfo recipeInfo = (RecipeInfo)entry.m_14419_();
            ResourceLocation recipeId = recipeInfo.getRecipeId();
            if (recipeState == ReloadableRecipeManager.RecipeState.KEEP && recipeInfo.getRecipe().isPresent()) {
                Recipe<?> recipe = recipeInfo.getRecipe().get();
                if (showRecipeToasts && isClient && !(recipeBook instanceof ServerRecipeBook) && !recipeBook.m_12711_(recipeId)) {
                    recipeBook.m_12723_(recipe);
                    RecipeBookUtil.showRecipeToast(recipe);
                }
                recipeBook.m_12700_(recipe);
                continue;
            }
            recipeBook.m_12715_(recipeId);
        }
        if (isClient) {
            RecipeBookUtil.refreshRecipeBook(recipeBook, registryManager);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void refreshRecipeBook(RecipeBook recipeBook, RegistryAccess registryManager) {
        Screen screen;
        if (!(recipeBook instanceof ClientRecipeBook)) {
            return;
        }
        ClientRecipeBook clientRecipeBook = (ClientRecipeBook)recipeBook;
        Minecraft client = Minecraft.m_91087_();
        ClientPacketListener network = Minecraft.m_91087_().m_91403_();
        if (network != null) {
            clientRecipeBook.m_266394_((Iterable)network.m_105141_().m_44051_(), registryManager);
            for (RecipeCollection collection : clientRecipeBook.m_90639_()) {
                collection.m_100499_((RecipeBook)clientRecipeBook);
            }
            client.m_231374_(SearchRegistry.f_119943_, clientRecipeBook.m_90639_());
        }
        if ((screen = Minecraft.m_91087_().f_91080_) instanceof RecipeUpdateListener) {
            RecipeUpdateListener recipeBookProvider = (RecipeUpdateListener)screen;
            recipeBookProvider.m_6916_();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void showRecipeToast(Recipe<?> recipe) {
        RecipeToast.m_94817_((ToastComponent)Minecraft.m_91087_().m_91300_(), recipe);
    }
}

