/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.building.entity.GlassItemFrame;
import org.violetmoon.quark.content.building.module.GlassItemFrameModule;

public class GlassItemFrameRenderer
extends EntityRenderer<GlassItemFrame> {
    private static final ModelResourceLocation LOCATION_MODEL = new ModelResourceLocation(new ResourceLocation("quark", "extra/glass_item_frame"), "inventory");
    private static final List<Direction> SIGN_DIRECTIONS = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);
    private static final BannerBlockEntity banner = new BannerBlockEntity(BlockPos.f_121853_, Blocks.f_50414_.m_49966_());
    private final ModelPart bannerModel;
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer;
    private final ItemFrameRenderer<?> defaultRenderer;

    public GlassItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart part = context.m_174023_(ModelLayers.f_171264_);
        this.bannerModel = part.m_171324_("flag");
        Minecraft mc = Minecraft.m_91087_();
        this.itemRenderer = mc.m_91291_();
        this.defaultRenderer = (ItemFrameRenderer)mc.m_91290_().f_114362_.get(EntityType.f_20462_);
    }

    public void render(@NotNull GlassItemFrame frame, float yaw, float partialTicks, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        super.m_7392_((Entity)frame, yaw, partialTicks, matrix, buffer, light);
        matrix.m_85836_();
        Direction direction = frame.m_6350_();
        Vec3 Vector3d = this.getRenderOffset(frame, partialTicks);
        matrix.m_85837_(-Vector3d.m_7096_(), -Vector3d.m_7098_(), -Vector3d.m_7094_());
        matrix.m_85837_((double)direction.m_122429_() * 0.46875, (double)direction.m_122430_() * 0.46875, (double)direction.m_122431_() * 0.46875);
        matrix.m_252781_(Axis.f_252529_.m_252977_(frame.m_146909_()));
        matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f - frame.m_146908_()));
        BlockRenderDispatcher blockrendererdispatcher = this.mc.m_91289_();
        ModelManager modelmanager = blockrendererdispatcher.m_110907_().m_110881_();
        ItemStack itemstack = frame.m_31822_();
        if (((Boolean)frame.m_20088_().m_135370_(GlassItemFrame.IS_SHINY)).booleanValue()) {
            light = 0xF000F0;
        }
        if (itemstack.m_41619_()) {
            matrix.m_85836_();
            matrix.m_85837_(-0.5, -0.5, -0.5);
            blockrendererdispatcher.m_110937_().m_111067_(matrix.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), null, modelmanager.m_119422_(LOCATION_MODEL), 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
            matrix.m_85849_();
        } else {
            this.renderItemStack(frame, matrix, buffer, light, itemstack);
        }
        matrix.m_85849_();
    }

    @NotNull
    public Vec3 getRenderOffset(GlassItemFrame frame, float partialTicks) {
        return new Vec3((double)((float)frame.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)frame.m_6350_().m_122431_() * 0.3f));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull GlassItemFrame frame) {
        return InventoryMenu.f_39692_;
    }

    protected boolean shouldShowName(@NotNull GlassItemFrame frame) {
        if (Minecraft.m_91404_() && !frame.m_31822_().m_41619_() && frame.m_31822_().m_41788_() && this.f_114476_.f_114359_ == frame) {
            double d0 = this.f_114476_.m_114471_((Entity)frame);
            float f = frame.m_20163_() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    protected void renderNameTag(@NotNull GlassItemFrame frame, @NotNull Component text, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int light) {
        super.m_7649_((Entity)frame, frame.m_31822_().m_41786_(), matrix, buffer, light);
    }

    protected void renderItemStack(GlassItemFrame itemFrame, PoseStack matrix, MultiBufferSource buff, int light, ItemStack stack) {
        if (!stack.m_41619_()) {
            matrix.m_85836_();
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)stack, (Level)itemFrame.m_9236_());
            if (itemFrame.isOnSign()) {
                GlassItemFrame.SignAttachment attach = itemFrame.getSignAttachment();
                Direction ourDirection = itemFrame.m_6350_().m_122424_();
                int signRotation = itemFrame.getOnSignRotation();
                int ourRotation = SIGN_DIRECTIONS.indexOf(ourDirection) * 4;
                int rotation = signRotation - ourRotation;
                float angle = (float)(-rotation) * 22.5f;
                float scale = 0.32f;
                switch (attach) {
                    case STANDING_BEHIND: {
                        angle += 180.0f;
                        break;
                    }
                    case WALL_SIGN: {
                        angle = 0.0f;
                        matrix.m_85837_(0.0, -0.3, 0.45);
                        break;
                    }
                    case HANGING_FROM_WALL: {
                        angle = 0.0f;
                        matrix.m_85837_(0.0, -0.52, -0.01);
                    }
                }
                matrix.m_85837_(0.0, 0.35, 0.98);
                matrix.m_85841_(scale, scale, scale);
                matrix.m_252781_(Axis.f_252436_.m_252977_(angle));
                switch (attach) {
                    case HANGING_IN_FRONT: {
                        matrix.m_85837_(0.0, -0.52 / (double)scale, -0.075);
                        break;
                    }
                    case HANGING_BEHIND: {
                        matrix.m_85837_(0.0, -0.52 / (double)scale, 0.3);
                    }
                }
                matrix.m_85837_(0.0, 0.0, -0.5);
                matrix.m_85837_(0.0, 0.0, -0.085);
            }
            int rotation = mapdata != null ? itemFrame.m_31823_() % 4 * 2 : itemFrame.m_31823_();
            matrix.m_252781_(Axis.f_252403_.m_252977_((float)rotation * 360.0f / 8.0f));
            if (!MinecraftForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent((ItemFrame)itemFrame, this.defaultRenderer, matrix, buff, light))) {
                if (mapdata != null) {
                    matrix.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrix.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
                    matrix.m_252880_(-64.0f, -64.0f, 62.5f);
                    Integer mapID = MapItem.m_151131_((ItemStack)stack);
                    this.mc.f_91063_.m_109151_().m_168771_(matrix, buff, mapID.intValue(), mapdata, true, light);
                } else {
                    float s = (float)GlassItemFrameModule.itemRenderScale;
                    Item ourRotation = stack.m_41720_();
                    if (ourRotation instanceof BannerItem) {
                        BannerItem bannerItem = (BannerItem)ourRotation;
                        banner.m_58489_(stack, bannerItem.m_40545_());
                        List patterns = banner.m_58508_();
                        matrix.m_85836_();
                        matrix.m_252880_(1.0E-4f, -0.5001f, 0.55f);
                        matrix.m_85841_(0.799999f, 0.399999f, 0.5f);
                        BannerRenderer.m_112065_((PoseStack)matrix, (MultiBufferSource)buff, (int)light, (int)OverlayTexture.f_118083_, (ModelPart)this.bannerModel, (Material)ModelBakery.f_119224_, (boolean)true, (List)patterns);
                        matrix.m_85849_();
                    } else {
                        if (stack.m_41720_() instanceof ShieldItem) {
                            matrix.m_252880_(-0.25f, 0.0f, 0.5f);
                            matrix.m_85841_(s *= 2.6666667f, s, s);
                        } else {
                            matrix.m_252880_(0.0f, 0.0f, 0.475f);
                            matrix.m_85841_(s, s, s);
                        }
                        matrix.m_85841_(0.5f, 0.5f, 0.5f);
                        this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, matrix, buff, (Level)this.mc.f_91073_, 0);
                    }
                }
            }
            matrix.m_85849_();
        }
    }
}

