/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.content.client.module.ChestSearchingModule;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class ShulkerBoxTooltips {
    public static final ResourceLocation WIDGET_RESOURCE = new ResourceLocation("quark", "textures/misc/shulker_widget.png");

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (SimilarBlockTypeHandler.isShulkerBox(stack)) {
            CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)false);
            if (cmp.m_128441_("LootTable")) {
                return;
            }
            if (!cmp.m_128441_("id")) {
                return;
            }
            BlockEntity te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), (CompoundTag)cmp);
            if (te != null && te.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                List tooltip = event.getTooltipElements();
                ArrayList tooltipCopy = new ArrayList(tooltip);
                for (int i = 1; i < tooltipCopy.size(); ++i) {
                    String s;
                    Either either = (Either)tooltipCopy.get(i);
                    if (!either.left().isPresent() || (s = ((FormattedText)either.left().get()).getString()).startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                    tooltip.remove(either);
                }
                if (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.m_96638_()) {
                    tooltip.add(1, Either.right((Object)new ShulkerComponent(stack)));
                }
                if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.m_96638_()) {
                    tooltip.add(1, Either.left((Object)Component.m_237115_((String)"quark.misc.shulker_box_shift")));
                }
            }
        }
    }

    public record ShulkerComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {9, 3}, {9, 5}, {9, 6}, {9, 8}, {9, 9}, {12, 9}};
        private static final int CORNER = 5;
        private static final int BUFFER = 1;
        private static final int EDGE = 18;

        public void m_183452_(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack pose = guiGraphics.m_280168_();
            CompoundTag cmp = ItemNBTHelper.getCompound((ItemStack)this.stack, (String)"BlockEntityTag", (boolean)true);
            if (cmp != null) {
                BlockEntity te;
                if (cmp.m_128441_("LootTable")) {
                    return;
                }
                if (!cmp.m_128441_("id")) {
                    cmp = cmp.m_6426_();
                    cmp.m_128359_("id", "minecraft:shulker_box");
                }
                if ((te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)this.stack.m_41720_()).m_40614_().m_49966_(), (CompoundTag)cmp)) != null) {
                    if (te instanceof RandomizableContainerBlockEntity) {
                        RandomizableContainerBlockEntity randomizable = (RandomizableContainerBlockEntity)te;
                        randomizable.m_59626_(null, 0L);
                    }
                    LazyOptional handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    handler.ifPresent(capability -> {
                        ShulkerBoxBlock boxBlock;
                        DyeColor dye;
                        Block patt5317$temp;
                        Window window;
                        int texWidth;
                        int right;
                        ItemStack currentBox = this.stack;
                        int currentX = tooltipX;
                        int currentY = tooltipY - 1;
                        int size = capability.getSlots();
                        int[] dims = new int[]{Math.min(size, 9), Math.max(size / 9, 1)};
                        for (int[] testAgainst : TARGET_RATIOS) {
                            if (testAgainst[0] * testAgainst[1] != size) continue;
                            dims = testAgainst;
                            break;
                        }
                        if ((right = currentX + (texWidth = 10 + 18 * dims[0])) > (window = mc.m_91268_()).m_85445_()) {
                            currentX -= right - window.m_85445_();
                        }
                        pose.m_85836_();
                        pose.m_252880_(0.0f, 0.0f, 700.0f);
                        int color = -1;
                        if (ImprovedTooltipsModule.shulkerBoxUseColors && (patt5317$temp = ((BlockItem)currentBox.m_41720_()).m_40614_()) instanceof ShulkerBoxBlock && (dye = (boxBlock = (ShulkerBoxBlock)patt5317$temp).m_56261_()) != null) {
                            float[] colorComponents = dye.m_41068_();
                            color = (int)(colorComponents[0] * 255.0f) << 16 | (int)(colorComponents[1] * 255.0f) << 8 | (int)(colorComponents[2] * 255.0f);
                        }
                        ShulkerComponent.renderTooltipBackground(guiGraphics, mc, pose, currentX, currentY, dims[0], dims[1], color);
                        for (int i = 0; i < size; ++i) {
                            ItemStack itemstack = capability.getStackInSlot(i);
                            int xp = currentX + 6 + i % 9 * 18;
                            int yp = currentY + 6 + i / 9 * 18;
                            if (!itemstack.m_41619_()) {
                                guiGraphics.m_280480_(itemstack, xp, yp);
                                guiGraphics.m_280370_(mc.f_91062_, itemstack, xp, yp);
                            }
                            if (((ChestSearchingModule)Quark.ZETA.modules.get(ChestSearchingModule.class)).namesMatch(itemstack)) continue;
                            RenderSystem.disableDepthTest();
                            guiGraphics.m_280509_(xp, yp, xp + 16, yp + 16, -1442840576);
                        }
                        pose.m_85849_();
                    });
                }
            }
        }

        public static void renderTooltipBackground(GuiGraphics guiGraphics, Minecraft mc, PoseStack matrix, int x, int y, int width, int height, int color) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGET_RESOURCE);
            RenderSystem.setShaderColor((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            guiGraphics.m_280163_(WIDGET_RESOURCE, x, y, 0.0f, 0.0f, 5, 5, 256, 256);
            guiGraphics.m_280163_(WIDGET_RESOURCE, x + 5 + 18 * width, y + 5 + 18 * height, 25.0f, 25.0f, 5, 5, 256, 256);
            guiGraphics.m_280163_(WIDGET_RESOURCE, x + 5 + 18 * width, y, 25.0f, 0.0f, 5, 5, 256, 256);
            guiGraphics.m_280163_(WIDGET_RESOURCE, x, y + 5 + 18 * height, 0.0f, 25.0f, 5, 5, 256, 256);
            for (int row = 0; row < height; ++row) {
                guiGraphics.m_280163_(WIDGET_RESOURCE, x, y + 5 + 18 * row, 0.0f, 6.0f, 5, 18, 256, 256);
                guiGraphics.m_280163_(WIDGET_RESOURCE, x + 5 + 18 * width, y + 5 + 18 * row, 25.0f, 6.0f, 5, 18, 256, 256);
                for (int col = 0; col < width; ++col) {
                    if (row == 0) {
                        guiGraphics.m_280163_(WIDGET_RESOURCE, x + 5 + 18 * col, y, 6.0f, 0.0f, 18, 5, 256, 256);
                        guiGraphics.m_280163_(WIDGET_RESOURCE, x + 5 + 18 * col, y + 5 + 18 * height, 6.0f, 25.0f, 18, 5, 256, 256);
                    }
                    guiGraphics.m_280163_(WIDGET_RESOURCE, x + 5 + 18 * col, y + 5 + 18 * row, 6.0f, 6.0f, 18, 18, 256, 256);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public int m_142103_() {
            return 65;
        }

        public int m_142069_(@NotNull Font font) {
            return 171;
        }
    }
}

