/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.entity.rang;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.entity.Toretoise;
import org.violetmoon.quark.content.tools.config.PickarangType;
import org.violetmoon.quark.content.tools.entity.rang.Flamerang;
import org.violetmoon.quark.content.tools.module.PickarangModule;

public abstract class AbstractPickarang<T extends AbstractPickarang<T>>
extends Projectile {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(AbstractPickarang.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(AbstractPickarang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private UUID ownerId;
    protected int liveTime;
    private int slot;
    private int blockHitCount;
    private IntOpenHashSet entitiesHit;
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_BLOCKS_BROKEN = "hitCount";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";

    public AbstractPickarang(EntityType<? extends AbstractPickarang<?>> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractPickarang(EntityType<? extends AbstractPickarang<?>> type, Level worldIn, LivingEntity throwerIn) {
        super(type, worldIn);
        Vec3 pos = throwerIn.m_20182_();
        this.m_6034_(pos.f_82479_, pos.f_82480_ + (double)throwerIn.m_20192_(), pos.f_82481_);
        this.ownerId = throwerIn.m_20148_();
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        Vec3 Vector3d = entityThrower.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(Vector3d.f_82479_, entityThrower.m_20096_() ? 0.0 : Vector3d.f_82480_, Vector3d.f_82481_));
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec);
        float f = (float)vec.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = (float)Math.sqrt(x * x + z * z);
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void setThrowData(int slot, ItemStack stack) {
        this.slot = slot;
        this.setStack(stack.m_41777_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STACK, (Object)new ItemStack((ItemLike)PickarangModule.pickarang));
        this.f_19804_.m_135372_(RETURNING, (Object)false);
    }

    protected void checkImpact() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 motion = this.m_20184_();
        Vec3 position = this.m_20182_();
        Vec3 rayEnd = position.m_82549_(motion);
        boolean doEntities = true;
        int tries = 100;
        while (this.m_6084_() && !this.isReturning()) {
            if (doEntities) {
                result = this.raycastEntities(position, rayEnd);
                if (result != null) {
                    this.m_6532_((HitResult)result);
                } else {
                    doEntities = false;
                }
            } else {
                result = this.m_9236_().m_45547_(new ClipContext(position, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (result.m_6662_() == HitResult.Type.MISS) {
                    return;
                }
                this.m_6532_((HitResult)result);
            }
            if (tries-- > 0) continue;
            new RuntimeException("Pickarang hit way too much, this shouldn't happen").printStackTrace();
            return;
        }
    }

    @Nullable
    protected EntityHitResult raycastEntities(Vec3 from, Vec3 to) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)from, (Vec3)to, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> !(entity.m_5833_() || !entity.m_6084_() || !entity.m_6087_() && !(entity instanceof AbstractPickarang) || entity == this.m_19749_() || this.entitiesHit != null && this.entitiesHit.contains(entity.m_19879_())));
    }

    protected boolean isBlockBlackListead(BlockState state) {
        return state.m_204336_(PickarangModule.pickarangImmuneTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_8060_(BlockHitResult result) {
        Entity entity;
        super.m_8060_(result);
        BlockPos hit = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(hit);
        if (this.getPiercingModifier() == 0 || state.m_280296_()) {
            this.addHit();
        }
        if (!((entity = this.m_19749_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack prev = player.m_21205_();
        try {
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, this.getStack());
            player.m_21008_(InteractionHand.MAIN_HAND, this.getStack());
            float progress = this.getBlockDestroyProgress(state, (Player)player, (BlockGetter)this.m_9236_(), hit);
            if (progress == 0.0f) {
                return;
            }
            float equivalentHardness = 1.0f / progress / 100.0f * 3.3333333f;
            if ((double)equivalentHardness <= this.getPickarangType().maxHardness && equivalentHardness >= 0.0f && !this.isBlockBlackListead(state) || player.m_150110_().f_35937_) {
                if (player.f_8941_.m_9280_(hit)) {
                    this.m_9236_().m_5898_(null, 2001, hit, Block.m_49956_((BlockState)state));
                } else {
                    this.clank((HitResult)result);
                }
                this.setStack(player.m_150109_().m_36056_());
            } else {
                this.clank((HitResult)result);
            }
        }
        finally {
            player.m_21008_(InteractionHand.MAIN_HAND, prev);
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, prev);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity owner = this.m_19749_();
        Entity hit = result.m_82443_();
        if (hit == owner) {
            return;
        }
        this.addHit(hit);
        if (hit instanceof AbstractPickarang) {
            AbstractPickarang apg = (AbstractPickarang)hit;
            apg.setReturning();
            this.clank((HitResult)result);
            return;
        }
        ItemStack pickarang = this.getStack();
        Multimap modifiers = pickarang.m_41638_(EquipmentSlot.MAINHAND);
        if (owner instanceof LivingEntity) {
            Toretoise toretoise;
            int ore;
            float prevHealth;
            LivingEntity leOwner = (LivingEntity)owner;
            ItemStack prev = leOwner.m_21205_();
            leOwner.m_21008_(InteractionHand.MAIN_HAND, pickarang);
            leOwner.m_21204_().m_22178_(modifiers);
            PickarangModule.setActivePickarangDamage(PickarangModule.getDamageSource((Entity)this, (Entity)leOwner));
            int ticksSinceLastSwing = leOwner.f_20922_;
            leOwner.f_20922_ = (int)(1.0 / leOwner.m_21133_(Attributes.f_22283_) * 20.0) + 1;
            float f = prevHealth = hit instanceof LivingEntity ? ((LivingEntity)hit).m_21223_() : 0.0f;
            if (hit instanceof Toretoise && (ore = (toretoise = (Toretoise)hit).getOreType()) != 0) {
                this.addHit((Entity)toretoise);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81463_, (Object)pickarang);
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        lootBuilder.m_287239_(player.m_36336_());
                    }
                    toretoise.dropOre(ore, lootBuilder);
                }
            } else {
                if (owner instanceof Player) {
                    Player p = (Player)owner;
                    p.m_5706_(hit);
                } else {
                    leOwner.m_7327_(hit);
                }
                if (hit instanceof LivingEntity && ((LivingEntity)hit).m_21223_() == prevHealth) {
                    this.clank((HitResult)result);
                }
            }
            leOwner.f_20922_ = ticksSinceLastSwing;
            this.setStack(leOwner.m_21205_());
            leOwner.m_21008_(InteractionHand.MAIN_HAND, prev);
            leOwner.m_21204_().m_22178_(modifiers);
            PickarangModule.setActivePickarangDamage(null);
        } else {
            AttributeSupplier.Builder mapBuilder = new AttributeSupplier.Builder();
            mapBuilder.m_22268_(Attributes.f_22281_, 1.0);
            AttributeSupplier map = mapBuilder.m_22265_();
            AttributeMap manager = new AttributeMap(map);
            manager.m_22178_(modifiers);
            ItemStack stack = this.getStack();
            stack.m_220157_(1, this.m_9236_().f_46441_, null);
            this.setStack(stack);
            hit.m_6469_(PickarangModule.getDamageSource((Entity)this, owner), (float)manager.m_22181_(Attributes.f_22281_));
        }
    }

    private float getBlockDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float f = state.m_60800_(level, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        float i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30.0f : 100.0f;
        float digSpeed = this.getPlayerDigSpeed(player, state, pos);
        return digSpeed / (f * i);
    }

    private float getPlayerDigSpeed(Player player, BlockState state, @Nullable BlockPos pos) {
        float f = 1.0f;
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            float f1 = switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= f1;
        }
        if (this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
            f /= 5.0f;
        }
        f = ForgeEventFactory.getBreakSpeed((Player)player, (BlockState)state, (float)f, (BlockPos)pos);
        return f;
    }

    public void spark() {
        this.m_5496_(QuarkSounds.ENTITY_PICKARANG_SPARK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void clank(HitResult hit) {
        if (hit instanceof BlockHitResult) {
            BlockHitResult bh = (BlockHitResult)hit;
            BlockState state = this.m_9236_().m_8055_(bh.m_82425_());
            Vec3 hitPos = bh.m_82450_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 2, 0.0, 0.0, 0.0, 0.0);
        }
        this.m_5496_(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void addHit(Entity entity) {
        if (this.entitiesHit == null) {
            this.entitiesHit = new IntOpenHashSet(5);
        }
        this.entitiesHit.add(entity.m_19879_());
        this.postHit();
    }

    public void postHit() {
        if ((this.entitiesHit == null ? 0 : this.entitiesHit.size()) + this.blockHitCount > this.getPiercingModifier()) {
            this.setReturning();
        } else if (this.getPiercingModifier() > 0) {
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        }
    }

    public void addHit() {
        ++this.blockHitCount;
        this.postHit();
    }

    protected void setReturning() {
        this.f_19804_.m_135381_(RETURNING, (Object)true);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        float drag;
        Vec3 pos = this.m_20182_();
        this.f_19790_ = pos.f_82479_;
        this.f_19791_ = pos.f_82480_;
        this.f_19792_ = pos.f_82481_;
        super.m_8119_();
        if (!this.isReturning()) {
            this.checkImpact();
        }
        Vec3 ourMotion = this.m_20184_();
        this.m_6034_(pos.f_82479_ + ourMotion.f_82479_, pos.f_82480_ + ourMotion.f_82480_, pos.f_82481_ + ourMotion.f_82481_);
        float f = (float)ourMotion.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)ourMotion.f_82479_, (double)ourMotion.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)ourMotion.f_82480_, (double)f) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        Level level = this.m_9236_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_ - ourMotion.f_82479_ * 0.25, pos.f_82480_ - ourMotion.f_82480_ * 0.25, pos.f_82481_ - ourMotion.f_82481_ * 0.25, ourMotion.f_82479_, ourMotion.f_82480_, ourMotion.f_82481_);
            }
            drag = 0.8f;
        } else {
            drag = 0.99f;
        }
        if (this.hasDrag()) {
            this.m_20256_(ourMotion.m_82490_((double)drag));
        }
        pos = this.m_20182_();
        this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        if (!this.m_6084_()) {
            return;
        }
        ItemStack stack = this.getStack();
        this.emitParticles(pos, ourMotion);
        boolean returning = this.isReturning();
        ++this.liveTime;
        Entity owner = this.m_19749_();
        if (owner == null || !owner.m_6084_() || !(owner instanceof Player)) {
            if (!level.f_46443_) {
                while (this.m_5830_()) {
                    this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                }
                this.m_5552_(stack, 0.0f);
                this.m_146870_();
            }
            return;
        }
        if (!returning) {
            if (this.liveTime > this.getPickarangType().timeout) {
                this.setReturning();
            }
            if (!level.m_6857_().m_61935_(this.m_20191_())) {
                this.spark();
            }
        } else {
            this.f_19794_ = true;
            int eff = this.getEfficiencyModifier();
            List items = level.m_45976_(ItemEntity.class, this.m_20191_().m_82400_(2.0));
            List xp = level.m_45976_(ExperienceOrb.class, this.m_20191_().m_82400_(2.0));
            Vec3 ourPos = this.m_20182_();
            for (ItemEntity item : items) {
                if (item.m_20159_()) continue;
                item.m_20329_((Entity)this);
                item.m_32010_(5);
            }
            for (ExperienceOrb xpOrb : xp) {
                if (xpOrb.m_20159_()) continue;
                xpOrb.m_20329_((Entity)this);
            }
            Vec3 ownerPos = owner.m_20182_().m_82520_(0.0, 1.0, 0.0);
            Vec3 motion = ownerPos.m_82546_(ourPos);
            double motionMag = 3.25 + (double)eff * 0.25;
            if (motion.m_82556_() < motionMag) {
                Player player = (Player)owner;
                Inventory inventory = player.m_150109_();
                ItemStack stackInSlot = inventory.m_8020_(this.slot);
                if (!level.f_46443_) {
                    this.m_5496_(QuarkSounds.ENTITY_PICKARANG_PICKUP, 1.0f, 1.0f);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        if (this instanceof Flamerang && this.m_6060_() && this.m_20197_().size() > 0) {
                            PickarangModule.useFlamerangTrigger.trigger(sp);
                        }
                    }
                    if (!stack.m_41619_()) {
                        if (player.m_6084_() && stackInSlot.m_41619_()) {
                            inventory.m_6836_(this.slot, stack);
                        } else if (!player.m_6084_() || !inventory.m_36054_(stack)) {
                            player.m_36176_(stack, false);
                        }
                    }
                    if (player.m_6084_()) {
                        for (ItemEntity item : items) {
                            if (!item.m_6084_()) continue;
                            this.giveItemToPlayer(player, item);
                        }
                        for (ExperienceOrb xpOrb : xp) {
                            if (!xpOrb.m_6084_()) continue;
                            xpOrb.m_6123_(player);
                        }
                        for (Entity riding : this.m_20197_()) {
                            if (!riding.m_6084_()) continue;
                            if (riding instanceof ItemEntity) {
                                this.giveItemToPlayer(player, (ItemEntity)riding);
                                continue;
                            }
                            if (!(riding instanceof ExperienceOrb)) continue;
                            riding.m_6123_(player);
                        }
                    }
                    this.m_146870_();
                }
            } else {
                this.m_20256_(motion.m_82541_().m_82490_(0.7 + (double)((float)eff * 0.325f)));
            }
        }
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(RETURNING);
    }

    protected void emitParticles(Vec3 pos, Vec3 ourMotion) {
    }

    public boolean hasDrag() {
        return true;
    }

    public abstract PickarangType<T> getPickarangType();

    private void giveItemToPlayer(Player player, ItemEntity itemEntity) {
        itemEntity.m_32010_(0);
        itemEntity.m_6123_(player);
        if (itemEntity.m_6084_()) {
            ItemStack drop = itemEntity.m_32055_();
            player.m_36176_(drop, false);
            itemEntity.m_146870_();
        }
    }

    protected boolean m_7310_(@NotNull Entity passenger) {
        return super.m_7310_(passenger) || passenger instanceof ItemEntity || passenger instanceof ExperienceOrb;
    }

    public double m_6048_() {
        return 0.0;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }

    public int getEfficiencyModifier() {
        return Quark.ZETA.itemExtensions.get(this.getStack()).getEnchantmentLevelZeta(this.getStack(), Enchantments.f_44984_);
    }

    public int getPiercingModifier() {
        return Quark.ZETA.itemExtensions.get(this.getStack()).getEnchantmentLevelZeta(this.getStack(), Enchantments.f_44961_);
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void setStack(ItemStack stack) {
        this.f_19804_.m_135381_(STACK, (Object)stack);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        Tag owner;
        this.f_19804_.m_135381_(RETURNING, (Object)compound.m_128471_(TAG_RETURNING));
        this.liveTime = compound.m_128451_(TAG_LIVE_TIME);
        this.blockHitCount = compound.m_128451_(TAG_BLOCKS_BROKEN);
        this.slot = compound.m_128451_(TAG_RETURN_SLOT);
        if (compound.m_128441_(TAG_ITEM_STACK)) {
            this.setStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_(TAG_ITEM_STACK)));
        } else {
            this.setStack(new ItemStack((ItemLike)PickarangModule.pickarang));
        }
        if (compound.m_128425_("owner", 10) && (owner = compound.m_128423_("owner")) != null) {
            this.ownerId = NbtUtils.m_129233_((Tag)owner);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        compound.m_128379_(TAG_RETURNING, this.isReturning());
        compound.m_128405_(TAG_LIVE_TIME, this.liveTime);
        compound.m_128405_(TAG_BLOCKS_BROKEN, this.blockHitCount);
        compound.m_128405_(TAG_RETURN_SLOT, this.slot);
        compound.m_128365_(TAG_ITEM_STACK, (Tag)this.getStack().serializeNBT());
        if (this.ownerId != null) {
            compound.m_128365_("owner", (Tag)NbtUtils.m_129226_((UUID)this.ownerId));
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

