/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit;

import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import dev.latvian.mods.unit.token.UnitToken;

public class FixedColorUnit
extends Unit
implements UnitToken {
    public static final FixedColorUnit WHITE = new FixedColorUnit(-1, true);
    public static final FixedColorUnit BLACK = new FixedColorUnit(-16777216, true);
    public static final FixedColorUnit TRANSPARENT = new FixedColorUnit(0, true);
    public final int color;
    public final boolean alpha;

    public static FixedColorUnit of(int color, boolean alpha) {
        if (color == -1) {
            return WHITE;
        }
        if (color == -16777216) {
            return BLACK;
        }
        if (color == 0) {
            return TRANSPARENT;
        }
        return new FixedColorUnit(color, alpha);
    }

    private FixedColorUnit(int c, boolean a) {
        this.color = c;
        this.alpha = a;
    }

    @Override
    public double get(UnitVariables variables) {
        return this.getInt(variables);
    }

    @Override
    public int getInt(UnitVariables variables) {
        return this.alpha ? this.color : this.color | 0xFF000000;
    }

    @Override
    public boolean getBoolean(UnitVariables variables) {
        return !this.alpha || (this.color >> 24 & 0xFF) != 0;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append(String.format(this.alpha ? "#%08X" : "#%06X", this.color));
    }

    @Override
    public Unit withAlpha(Unit a) {
        if (a instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)a;
            if (u.value >= 1.0) {
                return FixedColorUnit.of(this.color, false);
            }
            if (u.value <= 0.0) {
                return FixedColorUnit.of(this.color & 0xFFFFFF, true);
            }
            return FixedColorUnit.of(this.color & 0xFFFFFF | (int)(u.value * 255.0) << 24, true);
        }
        return super.withAlpha(a);
    }
}

