/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.capability;

import codechicken.lib.math.MathHelper;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.collection.Object2IntPair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class CapabilityCache {
    private final Map<Capability<?>, Object2IntPair<LazyOptional<?>>> selfCache = new HashMap();
    private final EnumMap<Direction, Map<Capability<?>, Object2IntPair<LazyOptional<?>>>> sideCache = new EnumMap(Direction.class);
    private Level world;
    private BlockPos pos;
    private int ticks;
    private int waitTicks = 100;

    public CapabilityCache() {
    }

    public CapabilityCache(Level world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setWaitTicks(int ticks) {
        this.waitTicks = ticks;
    }

    public void tick() {
        ++this.ticks;
    }

    public void setWorldPos(Level world, BlockPos pos) {
        this.clear();
        this.world = world;
        this.pos = pos;
    }

    public void clear() {
        this.selfCache.clear();
        Arrays.stream(Direction.f_122348_).map(this::getCacheForSide).forEach(Map::clear);
    }

    public void onNeighborChanged(BlockPos from) {
        if (this.world == null || this.pos == null) {
            return;
        }
        BlockPos offset = from.m_121996_((Vec3i)this.pos);
        int diff = MathHelper.absSum(offset);
        int side = MathHelper.toSide(offset);
        if (side < 0 || diff != 1) {
            return;
        }
        Direction sideChanged = Direction.f_122348_[side];
        Iterables.concat(this.selfCache.entrySet(), this.getCacheForSide(sideChanged).entrySet()).forEach(entry -> {
            Object2IntPair pair = (Object2IntPair)entry.getValue();
            if (pair.getKey() != null && !((LazyOptional)pair.getKey()).isPresent()) {
                pair.setKey(null);
                pair.setValue(this.ticks);
            }
        });
    }

    public <T> T getCapabilityOr(Capability<T> capability, Direction to, NonNullSupplier<T> default_) {
        return (T)this.getCapability(capability, to).orElseGet(default_);
    }

    public <T> T getCapabilityOr(Capability<T> capability, Direction to, T default_) {
        return (T)this.getCapability(capability, to).orElse(default_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction to) {
        Objects.requireNonNull(capability, "Null capability.");
        if (this.world == null || this.pos == null) {
            return LazyOptional.empty().cast();
        }
        Map<Capability<?>, Object2IntPair<LazyOptional<?>>> sideCache = this.getCacheForSide(to);
        Object2IntPair<LazyOptional<?>> cache = sideCache.get(capability);
        if (cache == null) {
            cache = new Object2IntPair<Object>(null, this.ticks);
            sideCache.put(capability, cache);
            return this.tryReCache(capability, to, cache).cast();
        }
        LazyOptional<?> lookup = cache.getKey();
        if (lookup == null || !lookup.isPresent()) {
            return this.tryReCache(capability, to, cache).cast();
        }
        return lookup.cast();
    }

    private LazyOptional<?> tryReCache(Capability<?> capability, Direction to, Object2IntPair<LazyOptional<?>> cache) {
        boolean isFirst;
        boolean bl = isFirst = cache.getKey() == null;
        if (!(!isFirst && cache.getKey().isPresent() || !isFirst && cache.getValue() + this.waitTicks > this.ticks)) {
            LazyOptional<?> lookup = this.requestCapability(capability, to);
            if (lookup.isPresent()) {
                cache.setKey(lookup);
                cache.setValue(this.ticks);
                lookup.addListener(l -> {
                    cache.setKey(LazyOptional.empty());
                    cache.setValue(this.ticks);
                });
            } else {
                cache.setKey(LazyOptional.empty());
                cache.setValue(this.ticks);
            }
        }
        return cache.getKey();
    }

    private LazyOptional<?> requestCapability(Capability<?> capability, Direction to) {
        Direction inverse;
        BlockEntity tile = this.world.m_7702_(this.pos.m_121945_(to));
        Direction direction = inverse = to == null ? null : to.m_122424_();
        if (tile != null) {
            return tile.getCapability(capability, inverse);
        }
        return LazyOptional.empty();
    }

    private Map<Capability<?>, Object2IntPair<LazyOptional<?>>> getCacheForSide(Direction side) {
        if (side == null) {
            return this.selfCache;
        }
        return this.sideCache.computeIfAbsent(side, s -> new HashMap());
    }
}

