/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryCopy
implements Container {
    public boolean[] accessible;
    public ItemStack[] items;
    public Container inv;

    public InventoryCopy(Container inv) {
        this.items = new ItemStack[inv.m_6643_()];
        ArrayUtils.fillArray(this.items, ItemStack.f_41583_, Objects::isNull);
        this.accessible = new boolean[inv.m_6643_()];
        this.inv = inv;
        this.update();
    }

    public void update() {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack stack = this.inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.items[i] = stack.m_41777_();
        }
    }

    public InventoryCopy open(InventoryRange access) {
        int lslot = access.lastSlot();
        if (lslot > this.accessible.length) {
            boolean[] l_accessible = new boolean[lslot];
            ItemStack[] l_items = new ItemStack[lslot];
            System.arraycopy(this.accessible, 0, l_accessible, 0, this.accessible.length);
            System.arraycopy(this.items, 0, l_items, 0, this.items.length);
            this.accessible = l_accessible;
            this.items = l_items;
        }
        for (int slot : access.slots) {
            this.accessible[slot] = true;
        }
        return this;
    }

    public int m_6643_() {
        return this.items.length;
    }

    public boolean m_7983_() {
        return ArrayUtils.count(this.items, stack -> !stack.m_41619_()) <= 0;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return this.inv.m_7013_(i, itemstack);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public void m_6211_() {
    }
}

