/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.util.recipes.RecipeJsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;

public class ThermalRecipeJS
extends RecipeJS {
    public InputItem readInputItem(Object from) {
        if (from instanceof JsonObject) {
            JsonObject j = (JsonObject)from;
            int amount = 1;
            Ingredient ingredient = j.has("value") ? Ingredient.m_43917_((JsonElement)j.get("value")) : Ingredient.m_43917_((JsonElement)j);
            if (j.has("count")) {
                amount = j.get("count").getAsInt();
            } else if (j.has("amount")) {
                amount = j.get("amount").getAsInt();
            }
            return InputItem.of((Ingredient)ingredient, (int)amount);
        }
        return super.readInputItem(from);
    }

    public JsonElement writeInputItem(InputItem value) {
        if (value.count > 1) {
            JsonObject json = new JsonObject();
            json.add("value", value.ingredient.m_43942_());
            json.addProperty("count", (Number)value.count);
            return json;
        }
        return value.ingredient.m_43942_();
    }

    public boolean inputFluidHasPriority(Object from) {
        JsonObject j;
        return from instanceof InputFluid || from instanceof JsonObject && ((j = (JsonObject)from).has("fluid") || j.has("fluid_tag"));
    }

    public InputFluid readInputFluid(Object from) {
        if (from instanceof InputFluid) {
            InputFluid input = (InputFluid)from;
            if (input instanceof FluidIngredient) {
                return input;
            }
            if (input instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)input;
                return (InputFluid)FluidIngredient.of((net.minecraftforge.fluids.FluidStack[])new net.minecraftforge.fluids.FluidStack[]{FluidStackHooksForge.toForge((FluidStack)fluid.getFluidStack())});
            }
        } else {
            if (from instanceof JsonElement) {
                JsonElement j = (JsonElement)from;
                return (InputFluid)RecipeJsonUtils.parseFluidIngredient((JsonElement)j);
            }
            if (from instanceof net.minecraftforge.fluids.FluidStack) {
                net.minecraftforge.fluids.FluidStack fluid = (net.minecraftforge.fluids.FluidStack)from;
                return (InputFluid)FluidIngredient.of((net.minecraftforge.fluids.FluidStack[])new net.minecraftforge.fluids.FluidStack[]{fluid});
            }
            List list = ListJS.orSelf((Object)from);
            ArrayList<net.minecraftforge.fluids.FluidStack> fluidStacks = new ArrayList<net.minecraftforge.fluids.FluidStack>();
            for (Object element : list) {
                FluidStackJS fluid = FluidStackJS.of(element);
                if (fluid.kjs$isEmpty()) continue;
                fluidStacks.add(FluidStackHooksForge.toForge((FluidStack)fluid.getFluidStack()));
            }
            if (!fluidStacks.isEmpty()) {
                return (InputFluid)FluidIngredient.of(fluidStacks.stream());
            }
        }
        return (InputFluid)FluidIngredient.EMPTY;
    }

    public JsonElement writeInputFluid(InputFluid value) {
        if (value instanceof FluidIngredient) {
            FluidIngredient fluid = (FluidIngredient)value;
            return fluid.toJson();
        }
        return FluidIngredient.EMPTY.toJson();
    }
}

