/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import me.roundaround.stackables.compat.StackablesTags;
import me.roundaround.stackables.config.StackablesConfig;
import me.roundaround.stackables.mixin.ItemAccessor;
import me.roundaround.stackables.roundalib.config.option.BooleanConfigOption;
import me.roundaround.stackables.roundalib.config.option.IntConfigOption;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StackablesMod
implements ModInitializer {
    public static final String MOD_ID = "stackables";
    public static final Logger LOGGER = LogManager.getLogger((String)"stackables");
    public static final StackablesConfig CONFIG = new StackablesConfig();
    private static final HashMap<class_2960, Integer> VANILLA_MAX_COUNTS = new HashMap();
    private static final ArrayList<Callback> CALLBACKS = new ArrayList();

    public void onInitialize() {
        CONFIG.init();
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.POTIONS, StackablesMod.CONFIG.POTION_COUNT, StackablesTags.POTIONS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.SPLASH_POTIONS, StackablesMod.CONFIG.SPLASH_POTION_COUNT, StackablesTags.SPLASH_POTIONS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.SOUPS, StackablesMod.CONFIG.SOUP_COUNT, StackablesTags.SOUPS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.ENCHANTED_BOOKS, StackablesMod.CONFIG.ENCHANTED_BOOK_COUNT, StackablesTags.ENCHANTED_BOOKS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.BOATS, StackablesMod.CONFIG.BOAT_COUNT, StackablesTags.BOATS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.MINECARTS, StackablesMod.CONFIG.MINECART_COUNT, StackablesTags.MINECARTS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.BUCKETS, StackablesMod.CONFIG.BUCKET_COUNT, StackablesTags.BUCKETS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.BEDS, StackablesMod.CONFIG.BED_COUNT, StackablesTags.BEDS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.DISCS, StackablesMod.CONFIG.DISC_COUNT, StackablesTags.MUSIC_DISCS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.INSTRUMENTS, StackablesMod.CONFIG.INSTRUMENT_COUNT, StackablesTags.INSTRUMENTS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.PATTERNS, StackablesMod.CONFIG.PATTERN_COUNT, StackablesTags.BANNER_PATTERNS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.HORSE_EQUIPMENTS, StackablesMod.CONFIG.HORSE_EQUIPMENT_COUNT, StackablesTags.HORSE_EQUIPMENT);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.CAKES, StackablesMod.CONFIG.CAKE_COUNT, StackablesTags.CAKES);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.TOTEMS, StackablesMod.CONFIG.TOTEM_COUNT, StackablesTags.TOTEMS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.DECORATED_POTS, StackablesMod.CONFIG.DECORATED_POT_COUNT, StackablesTags.DECORATED_POTS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.EMPTY_BUCKET_COUNT, StackablesTags.EMPTY_BUCKETS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.ARMOR_STAND_COUNT, StackablesTags.ARMOR_STANDS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.BANNER_COUNT, StackablesTags.BANNERS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.SIGN_COUNT, StackablesTags.SIGNS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.THROWABLE_COUNT, StackablesTags.THROWABLES);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.ENDER_PEARL_COUNT, StackablesTags.ENDER_PEARLS);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.DRINKABLE_COUNT, StackablesTags.DRINKABLES);
        this.syncTagMaxStackSizeWithConfig(StackablesMod.CONFIG.SIGNED_BOOK_COUNT, StackablesTags.SIGNED_BOOKS);
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> CALLBACKS.forEach(Callback::execute));
        StackablesMod.CONFIG.MOD_ENABLED.subscribeToValueChanges(null, (prev, curr) -> CALLBACKS.forEach(Callback::execute));
    }

    private void syncTagMaxStackSizeWithConfig(BooleanConfigOption toggleOption, IntConfigOption countOption, class_6862<class_1792> tag) {
        Callback callback = () -> this.setMaxCountForTag(tag, toggleOption, countOption);
        toggleOption.subscribeToValueChanges(null, (prev, curr) -> callback.execute());
        countOption.subscribeToValueChanges(null, (prev, curr) -> callback.execute());
        CALLBACKS.add(callback);
    }

    private void syncTagMaxStackSizeWithConfig(IntConfigOption countOption, class_6862<class_1792> tag) {
        Callback callback = () -> this.setMaxCountForTag(tag, countOption);
        countOption.subscribeToValueChanges(null, (prev, curr) -> callback.execute());
        CALLBACKS.add(callback);
    }

    private void setMaxCountForTag(class_6862<class_1792> tag, int count) {
        class_7923.field_41178.method_40260(tag).method_40239().forEach(entry -> {
            int vanillaMaxCount = this.getVanillaMaxCount((class_6880<class_1792>)entry);
            ((ItemAccessor)entry.comp_349()).setMaxCount(Math.max(count, vanillaMaxCount));
        });
    }

    private void setMaxCountForTag(class_6862<class_1792> tag, BooleanConfigOption toggleOption, IntConfigOption countOption) {
        int count = (Boolean)StackablesMod.CONFIG.MOD_ENABLED.getValue() != false && (Boolean)toggleOption.getValue() != false ? (Integer)countOption.getValue() : 1;
        this.setMaxCountForTag(tag, count);
    }

    private void setMaxCountForTag(class_6862<class_1792> tag, IntConfigOption countOption) {
        int count = (Boolean)StackablesMod.CONFIG.MOD_ENABLED.getValue() != false ? (Integer)countOption.getValue() : 1;
        this.setMaxCountForTag(tag, count);
    }

    private int getVanillaMaxCount(class_6880<class_1792> entry) {
        Optional key = entry.method_40230();
        if (key.isEmpty()) {
            return -1;
        }
        class_2960 id = ((class_5321)key.get()).method_29177();
        if (!VANILLA_MAX_COUNTS.containsKey(id)) {
            VANILLA_MAX_COUNTS.put(id, ((class_1792)entry.comp_349()).method_7882());
        }
        return VANILLA_MAX_COUNTS.get(id);
    }

    @FunctionalInterface
    static interface Callback {
        public void execute();
    }
}

