/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.config;

import java.util.Optional;
import me.roundaround.stackables.roundalib.config.ModConfig;
import me.roundaround.stackables.roundalib.config.option.BooleanConfigOption;
import me.roundaround.stackables.roundalib.config.option.IntConfigOption;
import me.roundaround.stackables.roundalib.shadow.nightconfig.core.Config;

public class StackablesConfig
extends ModConfig {
    public final BooleanConfigOption MOD_ENABLED = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "modEnabled", "stackables.mod_enabled.label").setComment("Simple toggle for the mod! Set to false to disable.")).build());
    public final BooleanConfigOption POTIONS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "potions", "stackables.potions.label").setComment("Whether to allow potions to stack.")).build());
    public final IntConfigOption POTION_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "potionCount", "stackables.potion_count.label").setComment("Maximum stack size for potions.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
    public final BooleanConfigOption SPLASH_POTIONS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "splashPotions", "stackables.splash_potions.label").setComment("Whether to allow splash potions to stack.")).build());
    public final IntConfigOption SPLASH_POTION_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "splashPotionCount", "stackables.splash_potion_count.label").setComment("Maximum stack size for splash potions.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
    public final IntConfigOption SPLASH_POTION_DELAY = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "splashPotionDelay", "stackables.splash_potion_delay.label").setComment("The delay/cooldown to add to throwing splash potions in game ticks.")).setMinValue(0).setMaxValue(20).setDefaultValue(0).build());
    public final BooleanConfigOption SOUPS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "soups", "stackables.soups.label").setComment("Whether to allow soups to stack.")).build());
    public final IntConfigOption SOUP_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "soupCount", "stackables.soup_count.label").setComment("Maximum stack size for soups.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
    public final BooleanConfigOption ENCHANTED_BOOKS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "enchantedBooks", "stackables.enchanted_books.label").setComment("Whether to allow enchanted books to stack.")).build());
    public final IntConfigOption ENCHANTED_BOOK_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "enchantedBookCount", "stackables.enchanted_book_count.label").setComment("Maximum stack size for enchanted books.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
    public final BooleanConfigOption BOATS;
    public final IntConfigOption BOAT_COUNT;
    public final BooleanConfigOption MINECARTS;
    public final IntConfigOption MINECART_COUNT;
    public final BooleanConfigOption BUCKETS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "buckets", "stackables.buckets.label").setComment("Whether to allow full buckets to stack.")).build());
    public final IntConfigOption BUCKET_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "bucketCount", "stackables.bucket_count.label").setComment("Maximum stack size for full buckets.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
    public final BooleanConfigOption BEDS;
    public final IntConfigOption BED_COUNT;
    public final BooleanConfigOption DISCS;
    public final IntConfigOption DISC_COUNT;
    public final BooleanConfigOption INSTRUMENTS;
    public final IntConfigOption INSTRUMENT_COUNT;
    public final BooleanConfigOption PATTERNS;
    public final IntConfigOption PATTERN_COUNT;
    public final BooleanConfigOption HORSE_EQUIPMENTS;
    public final IntConfigOption HORSE_EQUIPMENT_COUNT;
    public final BooleanConfigOption CAKES;
    public final IntConfigOption CAKE_COUNT;
    public final BooleanConfigOption TOTEMS;
    public final IntConfigOption TOTEM_COUNT;
    public final BooleanConfigOption DECORATED_POTS;
    public final IntConfigOption DECORATED_POT_COUNT;
    public final IntConfigOption EMPTY_BUCKET_COUNT;
    public final IntConfigOption ARMOR_STAND_COUNT;
    public final IntConfigOption BANNER_COUNT;
    public final IntConfigOption SIGN_COUNT;
    public final IntConfigOption THROWABLE_COUNT;
    public final IntConfigOption ENDER_PEARL_COUNT;
    public final IntConfigOption DRINKABLE_COUNT;
    public final IntConfigOption SIGNED_BOOK_COUNT;

    public StackablesConfig() {
        super("stackables", ModConfig.options("stackables").setConfigVersion(2));
        this.BOATS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "boats", "stackables.boats.label").setComment("Whether to allow boats to stack.")).build());
        this.BOAT_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "boatCount", "stackables.boat_count.label").setComment("Maximum stack size for boats.")).setMinValue(1).setMaxValue(64).setDefaultValue(64).build());
        this.MINECARTS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "minecarts", "stackables.minecarts.label").setComment("Whether to allow minecarts to stack.")).build());
        this.MINECART_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "minecartCount", "stackables.minecart_count.label").setComment("Maximum stack size for minecarts.")).setMinValue(1).setMaxValue(64).setDefaultValue(64).build());
        this.BEDS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "beds", "stackables.beds.label").setComment("Whether to allow beds to stack.")).build());
        this.BED_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "bedCount", "stackables.bed_count.label").setComment("Maximum stack size for beds.")).setMinValue(1).setMaxValue(64).setDefaultValue(64).build());
        this.DISCS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "discs", "stackables.discs.label").setComment("Whether to allow music discs to stack.")).build());
        this.DISC_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "discCount", "stackables.disc_count.label").setComment("Maximum stack size for music discs.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.INSTRUMENTS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "instruments", "stackables.instruments.label").setComment("Whether to allow instruments (i.e. goat horns) to stack.")).build());
        this.INSTRUMENT_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "instrumentCount", "stackables.instrument_count.label").setComment("Maximum stack size for instruments (i.e. goat horns).")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.PATTERNS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "patterns", "stackables.patterns.label").setComment("Whether to allow banner patterns to stack.")).build());
        this.PATTERN_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "patternCount", "stackables.pattern_count.label").setComment("Maximum stack size for banner patterns.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.HORSE_EQUIPMENTS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "horseEquipments", "stackables.horse_equipments.label").setComment("Whether to allow horse equipments (i.e. saddles and armor) to stack.")).build());
        this.HORSE_EQUIPMENT_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "horseEquipmentCount", "stackables.horse_equipment_count.label").setComment("Maximum stack size for horse equipment (i.e. saddles and armor).")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.CAKES = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "cakes", "stackables.cakes.label").setComment("Whether to allow cakes to stack.")).build());
        this.CAKE_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "cakeCount", "stackables.cake_count.label").setComment("Maximum stack size for cakes.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.TOTEMS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "totems", "stackables.totems.label").setComment("Whether to allow totems to stack.")).build());
        this.TOTEM_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "totemCount", "stackables.totem_count.label").setComment("Maximum stack size for totems.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.DECORATED_POTS = this.registerConfigOption(((BooleanConfigOption.Builder)BooleanConfigOption.yesNoBuilder((ModConfig)this, "decoratedPots", "stackables.decorated_pots.label").setComment("Whether to allow decorated pots to stack.")).build());
        this.DECORATED_POT_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "decoratedPotCount", "stackables.decorated_pot_count.label").setComment("Maximum stack size for decorated pots.")).setMinValue(1).setMaxValue(64).setDefaultValue(64).build());
        this.EMPTY_BUCKET_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "emptyBucketCount", "stackables.empty_bucket_count.label").setComment("Maximum stack size for empty buckets.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.ARMOR_STAND_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "armorStandCount", "stackables.armor_stand_count.label").setComment("Maximum stack size for armor stands.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.BANNER_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "bannerCount", "stackables.banner_count.label").setComment("Maximum stack size for banners.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.SIGN_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "signCount", "stackables.sign_count.label").setComment("Maximum stack size for signs.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.THROWABLE_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "throwableCount", "stackables.throwable_count.label").setComment("Maximum stack size for throwables (i.e. snowballs and chicken eggs).")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.ENDER_PEARL_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "enderPearlCount", "stackables.ender_pearl_count.label").setComment("Maximum stack size for ender pearls.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.DRINKABLE_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "drinkableCount", "stackables.drinkable_count.label").setComment("Maximum stack size for drinkables (i.e. honey bottles and milk buckets).")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
        this.SIGNED_BOOK_COUNT = this.registerConfigOption(((IntConfigOption.Builder)IntConfigOption.builder((ModConfig)this, "signedBookCount", "stackables.signed_book_count.label").setComment("Maximum stack size for signed books.")).setMinValue(1).setMaxValue(64).setDefaultValue(16).build());
    }

    @Override
    protected boolean updateConfigVersion(int version, Config config) {
        if (version == 1) {
            StackablesConfig.getBooleanFromOldId(config, "horns").ifPresent(value -> StackablesConfig.setBoolean(config, "instruments", value));
            StackablesConfig.getIntegerFromOldId(config, "hornCount").ifPresent(value -> StackablesConfig.setInteger(config, "instrumentCount", value));
            StackablesConfig.getBooleanFromOldId(config, "saddles").ifPresent(value -> StackablesConfig.setBoolean(config, "horseEquipments", value));
            StackablesConfig.getIntegerFromOldId(config, "saddleCount").ifPresent(value -> StackablesConfig.setInteger(config, "horseEquipmentCount", value));
            StackablesConfig.getIntegerFromOldId(config, "bucketCount").ifPresent(value -> StackablesConfig.setInteger(config, "emptyBucketCount", value));
            Optional<Integer> eggCount = StackablesConfig.getIntegerFromOldId(config, "eggCount");
            Optional<Integer> snowballCount = StackablesConfig.getIntegerFromOldId(config, "snowballCount");
            int maxPreviousCount = Math.max(eggCount.orElse(-1), snowballCount.orElse(-1));
            if (maxPreviousCount != -1) {
                StackablesConfig.setInteger(config, "throwableCount", maxPreviousCount);
            }
            StackablesConfig.getIntegerFromOldId(config, "honeyBottleCount").ifPresent(value -> StackablesConfig.setInteger(config, "drinkableCount", value));
            return true;
        }
        return false;
    }

    private static void setBoolean(Config config, String id, boolean value) {
        String path = String.format("%s.%s", "stackables", id);
        config.set(path, (Object)value);
    }

    private static void setInteger(Config config, String id, int value) {
        String path = String.format("%s.%s", "stackables", id);
        config.set(path, (Object)value);
    }

    private static Optional<Boolean> getBooleanFromOldId(Config config, String oldId) {
        String path = String.format("%s.%s", "stackables", oldId);
        if (!config.contains(path)) {
            return Optional.empty();
        }
        boolean value = (Boolean)config.get(path);
        config.remove(path);
        return Optional.of(value);
    }

    private static Optional<Integer> getIntegerFromOldId(Config config, String oldId) {
        String path = String.format("%s.%s", "stackables", oldId);
        if (!config.contains(path)) {
            return Optional.empty();
        }
        int value = (Integer)config.get(path);
        config.remove(path);
        return Optional.of(value);
    }
}

