/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.config.RoundaLibIconButtons;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_757;

public abstract class ConfigOptionSubScreen<D, O extends ConfigOption<D, ?>>
extends class_437 {
    protected static final int DARKEN_STRENGTH = 120;
    protected final class_437 parent;
    protected final O configOption;
    protected final O workingCopy;
    protected final String modId;

    protected ConfigOptionSubScreen(class_2561 title, class_437 parent, O configOption) {
        super(title);
        this.parent = parent;
        this.configOption = configOption;
        this.workingCopy = ((ConfigOption)configOption).createWorkingCopy();
        this.modId = ((ConfigOption)configOption).getConfig().getModId();
    }

    protected void method_25426() {
        this.method_25429((class_364)RoundaLibIconButtons.resetButton(this.field_22789 - 3 * (GuiUtil.PADDING + 13), this.field_22790 - GuiUtil.PADDING - 13, this.workingCopy));
        this.method_25429((class_364)RoundaLibIconButtons.discardButton(this.field_22789 - 2 * (GuiUtil.PADDING + 13), this.field_22790 - GuiUtil.PADDING - 13, ((ConfigOption)this.configOption).getConfig().getModId(), button -> this.discardAndExit()));
        this.method_25429((class_364)RoundaLibIconButtons.saveButton(this.field_22789 - GuiUtil.PADDING - 13, this.field_22790 - GuiUtil.PADDING - 13, ((ConfigOption)this.configOption).getConfig().getModId(), button -> this.saveAndExit()));
    }

    public void method_25419() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: {
                this.discardAndExit();
                return true;
            }
            case 83: {
                if (class_437.method_25441()) {
                    this.saveAndExit();
                    return true;
                }
            }
            case 82: {
                if (!class_437.method_25441()) break;
                this.resetToDefault();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(drawContext, mouseX, mouseY, partialTicks);
        this.renderContent(drawContext, mouseX, mouseY, partialTicks);
        this.renderHelp(drawContext, mouseX, mouseY, partialTicks);
    }

    protected void renderBackground(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.parent == null) {
            this.renderTextureBackground(drawContext, mouseX, mouseY, partialTicks);
        } else {
            this.renderDarkenBackground(drawContext, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderTextureBackground(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912(0.0, (double)this.field_22790, 0.0).method_22913(0.0f, (float)this.field_22790 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, (double)this.field_22790, 0.0).method_22913((float)this.field_22789 / 32.0f, (float)this.field_22790 / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, 0.0, 0.0).method_22913((float)this.field_22789 / 32.0f, 0.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, 0.0f).method_1336(64, 64, 64, 255).method_1344();
        tessellator.method_1350();
    }

    protected void renderDarkenBackground(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912(0.0, (double)this.field_22790, 0.0).method_1336(0, 0, 0, 120).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, (double)this.field_22790, 0.0).method_1336(0, 0, 0, 120).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, 0.0, 0.0).method_1336(0, 0, 0, 120).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, 0.0).method_1336(0, 0, 0, 120).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void renderContent(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        drawContext.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 17, GuiUtil.LABEL_COLOR);
        this.method_25396().forEach(child -> {
            if (child instanceof class_4068) {
                ((class_4068)child).method_25394(drawContext, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void renderHelp(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (ConfigOptionSubScreen.method_25442()) {
            this.renderHelpExpanded(drawContext, mouseX, mouseY, partialTicks);
        } else {
            this.renderHelpPrompt(drawContext, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderHelpPrompt(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        this.renderHelpLines(drawContext, this.getHelpShort(mouseX, mouseY, partialTicks));
    }

    protected void renderHelpExpanded(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        this.renderHelpLines(drawContext, this.getHelpLong(mouseX, mouseY, partialTicks));
    }

    private void renderHelpLines(class_332 drawContext, List<class_2561> lines) {
        this.renderHelpLines(drawContext, lines, false);
    }

    private void renderHelpLines(class_332 drawContext, List<class_2561> lines, boolean offsetForIcon) {
        Objects.requireNonNull(this.field_22793);
        int n = lines.size() - 1;
        Objects.requireNonNull(this.field_22793);
        int startingOffset = this.field_22790 - 4 - 9 - n * (9 + 2);
        for (int i = 0; i < lines.size(); ++i) {
            Objects.requireNonNull(this.field_22793);
            drawContext.method_27535(this.field_22793, lines.get(i), 4, startingOffset + i * (9 + 2), GuiUtil.LABEL_COLOR);
        }
    }

    protected List<class_2561> getHelpShort(int mouseX, int mouseY, float partialTicks) {
        return List.of(class_2561.method_43471((String)(this.modId + ".roundalib.help.short")));
    }

    protected List<class_2561> getHelpLong(int mouseX, int mouseY, float partialTicks) {
        return List.of(class_2561.method_43471((String)(this.modId + ".roundalib.help.cancel")), class_310.field_1703 ? class_2561.method_43471((String)(this.modId + ".roundalib.help.save.mac")) : class_2561.method_43471((String)(this.modId + ".roundalib.help.save.win")), class_310.field_1703 ? class_2561.method_43471((String)(this.modId + ".roundalib.help.reset.mac")) : class_2561.method_43471((String)(this.modId + ".roundalib.help.reset.win")));
    }

    protected void setValue(D value) {
        ((ConfigOption)this.workingCopy).setValue(value);
    }

    protected D getValue() {
        return ((ConfigOption)this.workingCopy).getValue();
    }

    protected void resetToDefault() {
        ((ConfigOption)this.workingCopy).resetToDefault();
    }

    protected boolean isDirty() {
        return ((ConfigOption)this.workingCopy).isDirty();
    }

    protected void commitValueToConfig() {
        ((ConfigOption)this.configOption).setValue(this.getValue());
    }

    protected void discardAndExit() {
        this.method_25419();
    }

    protected void saveAndExit() {
        this.commitValueToConfig();
        this.method_25419();
    }
}

