/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.roundaround.stackables.roundalib.RoundaLib;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.LabelWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.VariableHeightListWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.Control;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ControlRegistry;
import me.roundaround.stackables.roundalib.client.gui.widget.config.RoundaLibIconButtons;
import me.roundaround.stackables.roundalib.config.ModConfig;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4264;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

public class ConfigListWidget
extends VariableHeightListWidget<Entry> {
    public ConfigListWidget(class_310 client, ModConfig modConfig, int left, int top, int width, int height) {
        super(client, left, top, width, height);
        for (Map.Entry<String, LinkedList<ConfigOption<?, ?>>> entry : modConfig.getConfigOptions().entrySet()) {
            if (entry.getValue().stream().noneMatch(ConfigOption::shouldShowInConfigScreen)) continue;
            String modId = modConfig.getModId();
            String category = entry.getKey();
            if (modConfig.getShowGroupTitles() && !category.equals(modId)) {
                this.addEntry(new CategoryEntry(this.client, this, (class_2561)class_2561.method_43471((String)(entry.getKey() + ".title"))));
            }
            for (ConfigOption configOption : entry.getValue()) {
                if (!configOption.shouldShowInConfigScreen()) continue;
                try {
                    this.addEntry(new OptionEntry(this.client, this, configOption));
                }
                catch (ControlRegistry.NotRegisteredException e) {
                    RoundaLib.LOGGER.error("Failed to create control for config option: " + configOption, (Throwable)e);
                }
            }
        }
    }

    public void tick() {
        this.entries.forEach(Entry::tick);
    }

    public static class CategoryEntry
    extends Entry {
        protected static final int HEIGHT = 20;
        protected final LabelWidget labelWidget;

        protected CategoryEntry(class_310 client, ConfigListWidget parent, class_2561 label) {
            super(client, parent, 20);
            this.labelWidget = LabelWidget.builder(client, label, this.getLeft() + this.getWidth() / 2, this.getTop() + this.getHeight() / 2).justifiedCenter().alignedMiddle().shiftForPadding().showTextShadow().hideBackground().build();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        @Override
        public void renderContent(class_332 drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
            this.labelWidget.setPosY(this.getTop() + this.getHeight() / 2 - (int)scrollAmount);
            this.labelWidget.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    public static class OptionEntry<D, O extends ConfigOption<D, ?>>
    extends Entry {
        protected static final int HEIGHT = 20;
        protected final O option;
        protected final Control<D, O> control;
        protected final LabelWidget labelWidget;
        protected final IconButtonWidget resetButton;

        protected OptionEntry(class_310 client, ConfigListWidget parent, O configOption) throws ControlRegistry.NotRegisteredException {
            super(client, parent, 20);
            this.option = configOption;
            this.control = ControlRegistry.getControlFactory(configOption).create(this);
            this.labelWidget = LabelWidget.builder(client, ((ConfigOption)configOption).getLabel(), this.getLeft() + GuiUtil.PADDING, this.getTop() + this.getHeight() / 2).justifiedLeft().alignedMiddle().shiftForPadding().showTextShadow().hideBackground().build();
            this.resetButton = RoundaLibIconButtons.resetButton(this.getControlRight() + GuiUtil.PADDING, this.getTop() + (this.getHeight() - 18) / 2, this.option, 18);
        }

        public O getOption() {
            return this.option;
        }

        public int getControlRight() {
            return this.getRight() - 18 - 2 * GuiUtil.PADDING;
        }

        public List<? extends class_364> method_25396() {
            return Stream.of(this.control.method_25396(), List.of(this.resetButton)).flatMap(Collection::stream).toList();
        }

        protected List<? extends class_364> navigableChildren() {
            return this.method_25396().stream().filter(element -> {
                if (element instanceof class_4264) {
                    class_4264 pressable = (class_4264)element;
                    return pressable.field_22763;
                }
                return true;
            }).toList();
        }

        @Override
        public class_8016 getNavigationPath(class_8023 navigation, int index) {
            List<class_364> navigableChildren = this.navigableChildren();
            if (navigableChildren.isEmpty()) {
                return null;
            }
            class_364 child = navigableChildren.get(Math.min(index, navigableChildren.size() - 1));
            class_8016 path = child.method_48205(navigation);
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }

        @Override
        public void tick() {
            this.control.tick();
        }

        @Override
        public void renderContent(class_332 drawContext, int index, double scrollAmount, int mouseX, int mouseY, float delta) {
            this.labelWidget.setPosY(this.getTop() + this.getHeight() / 2 - (int)scrollAmount);
            this.labelWidget.method_25394(drawContext, mouseX, mouseY, delta);
            this.control.setScrollAmount(scrollAmount);
            this.control.renderWidget(drawContext, mouseX, mouseY, delta);
            this.resetButton.method_46419(this.getTop() + (this.getHeight() - 18) / 2 - (int)scrollAmount);
            this.resetButton.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    public static abstract class Entry
    extends VariableHeightListWidget.Entry<Entry> {
        protected Entry(class_310 client, ConfigListWidget parent, int height) {
            super(client, parent, height);
        }

        public void tick() {
        }

        @Override
        public ConfigListWidget getParent() {
            return super.getParent();
        }
    }
}

