/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.util.HashMap;
import me.roundaround.stackables.roundalib.RoundaLib;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ConfigListWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.Control;
import me.roundaround.stackables.roundalib.client.gui.widget.config.FloatSliderControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.FloatTextControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.IntSliderControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.IntTextControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.OptionListControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.SubScreenControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.TextControl;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ToggleControl;
import me.roundaround.stackables.roundalib.config.option.BooleanConfigOption;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import me.roundaround.stackables.roundalib.config.option.FloatConfigOption;
import me.roundaround.stackables.roundalib.config.option.IntConfigOption;
import me.roundaround.stackables.roundalib.config.option.OptionListConfigOption;
import me.roundaround.stackables.roundalib.config.option.StringConfigOption;
import me.roundaround.stackables.roundalib.config.value.Difficulty;
import me.roundaround.stackables.roundalib.config.value.GameMode;
import me.roundaround.stackables.roundalib.config.value.GuiAlignment;
import me.roundaround.stackables.roundalib.config.value.GuiAlignmentWithCenter;
import me.roundaround.stackables.roundalib.config.value.GuiTheme;
import me.roundaround.stackables.roundalib.config.value.ListOptionValue;

public class ControlRegistry {
    private static final HashMap<Class<?>, ControlFactory<?, ?>> byClazz = new HashMap();
    private static final HashMap<Class<?>, ControlFactory<?, ?>> byOptionListClazz = new HashMap();
    private static final HashMap<String, ControlFactory<?, ?>> byId = new HashMap();

    private ControlRegistry() {
    }

    private static void registerDefaults() {
        try {
            ControlRegistry.register(BooleanConfigOption.class, ToggleControl::new);
            ControlRegistry.register(StringConfigOption.class, TextControl::new);
            ControlRegistry.register(IntConfigOption.class, ControlRegistry::intControlFactory);
            ControlRegistry.register(FloatConfigOption.class, ControlRegistry::floatControlFactory);
            ControlRegistry.registerOptionList(Difficulty.class);
            ControlRegistry.registerOptionList(GameMode.class);
            ControlRegistry.registerOptionList(GuiAlignment.class);
            ControlRegistry.registerOptionList(GuiAlignmentWithCenter.class);
            ControlRegistry.registerOptionList(GuiTheme.class);
        }
        catch (RegistrationException e) {
            RoundaLib.LOGGER.error("There was an error registering the built-in control factories!", (Throwable)e);
            System.exit(0);
        }
    }

    public static <D, T extends ConfigOption<D, ?>> void register(Class<T> clazz, ControlFactory<D, T> factory) throws RegistrationException {
        if (byClazz.containsKey(clazz)) {
            throw new RegistrationException();
        }
        byClazz.put(clazz, factory);
    }

    public static <S extends ListOptionValue<S>> void registerOptionList(Class<S> clazz) throws RegistrationException {
        ControlRegistry.registerOptionList(clazz, OptionListControl::new);
    }

    public static <S extends ListOptionValue<S>, T extends OptionListConfigOption<S>> void registerOptionList(Class<S> clazz, ControlFactory<S, T> factory) throws RegistrationException {
        if (byOptionListClazz.containsKey(clazz)) {
            throw new RegistrationException();
        }
        byOptionListClazz.put(clazz, factory);
    }

    public static <D, T extends ConfigOption<D, ?>> void register(String id, ControlFactory<D, T> factory) throws RegistrationException {
        if (byId.containsKey(id)) {
            throw new RegistrationException();
        }
        byId.put(id, factory);
    }

    public static <D, T extends ConfigOption<D, ?>> ControlFactory<D, T> getControlFactory(T configOption) throws NotRegisteredException {
        Class<?> subClazz;
        String id = configOption.getId();
        if (byId.containsKey(id)) {
            return byId.get(id);
        }
        Class<?> clazz = configOption.getClass();
        if (byClazz.containsKey(clazz)) {
            return byClazz.get(clazz);
        }
        if (clazz.equals(OptionListConfigOption.class) && byOptionListClazz.containsKey(subClazz = configOption.getValue().getClass())) {
            return byOptionListClazz.get(subClazz);
        }
        throw new NotRegisteredException();
    }

    public static <D, O extends ConfigOption<D, ?>> ControlFactory<D, O> createSubScreenControlFactory(SubScreenControl.SubScreenFactory<D, O> subScreenFactory) {
        return parent -> new SubScreenControl(parent, subScreenFactory);
    }

    private static Control<Integer, IntConfigOption> intControlFactory(ConfigListWidget.OptionEntry<Integer, IntConfigOption> parent) {
        ControlFactory<Integer, IntConfigOption> constructor = parent.getOption().useSlider() ? IntSliderControl::new : IntTextControl::new;
        return constructor.create(parent);
    }

    private static Control<Float, FloatConfigOption> floatControlFactory(ConfigListWidget.OptionEntry<Float, FloatConfigOption> parent) {
        ControlFactory<Float, FloatConfigOption> constructor = parent.getOption().useSlider() ? FloatSliderControl::new : FloatTextControl::new;
        return constructor.create(parent);
    }

    static {
        ControlRegistry.registerDefaults();
    }

    @FunctionalInterface
    public static interface ControlFactory<D, O extends ConfigOption<D, ?>> {
        public Control<D, O> create(ConfigListWidget.OptionEntry<D, O> var1);
    }

    public static class RegistrationException
    extends Exception {
    }

    public static class NotRegisteredException
    extends Exception {
    }
}

