/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import me.roundaround.stackables.roundalib.client.gui.GuiUtil;
import me.roundaround.stackables.roundalib.client.gui.widget.config.ConfigListWidget;
import me.roundaround.stackables.roundalib.client.gui.widget.config.Control;
import me.roundaround.stackables.roundalib.config.option.FloatConfigOption;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;

public class FloatTextControl
extends Control<Float, FloatConfigOption> {
    private static final List<Character> ALLOWED_SPECIAL_CHARS = List.of(Character.valueOf('.'), Character.valueOf(','));
    private final class_342 textField;

    public FloatTextControl(ConfigListWidget.OptionEntry<Float, FloatConfigOption> parent) {
        super(parent);
        this.textField = new class_342(parent.getTextRenderer(), this.widgetLeft + 1, this.widgetTop + 1, this.widgetWidth - 2, this.widgetHeight - 2, ((FloatConfigOption)this.option).getLabel()){

            public boolean method_25400(char chr, int keyCode) {
                if (chr == '-' && this.method_1881() > 0) {
                    return false;
                }
                if (!FloatTextControl.isCharAllowed(chr)) {
                    return false;
                }
                return super.method_25400(chr, keyCode);
            }
        };
        this.textField.method_1852(((Float)((FloatConfigOption)this.option).getValue()).toString());
        this.textField.method_1880(12);
        this.textField.method_1863(this::onTextChanged);
        this.onDisabledChange(this.disabled, this.disabled);
    }

    public List<? extends class_364> method_25396() {
        return List.of(this.textField);
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        super.setScrollAmount(scrollAmount);
        this.textField.method_46419(this.scrolledTop + 1);
    }

    @Override
    public void markInvalid() {
        this.textField.method_1868(GuiUtil.ERROR_COLOR);
        super.markInvalid();
    }

    @Override
    public void markValid() {
        this.textField.method_1868(GuiUtil.LABEL_COLOR);
        super.markValid();
    }

    @Override
    public void tick() {
        super.tick();
        this.textField.method_1865();
    }

    @Override
    public void renderWidget(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.textField.method_25394(drawContext, mouseX, mouseY, delta);
    }

    @Override
    protected void onConfigValueChange(Float prev, Float curr) {
        try {
            float parsed = this.parseFloat(this.textField.method_1882());
            if (Math.abs(curr.floatValue() - parsed) < 1.0E-5f) {
                return;
            }
            this.textField.method_1852(curr.toString());
        }
        catch (Exception e) {
            this.textField.method_1852(curr.toString());
        }
    }

    @Override
    protected void onDisabledChange(boolean prev, boolean curr) {
        this.textField.field_22763 = !this.disabled;
        this.textField.method_1888(!this.disabled);
    }

    private void onTextChanged(String value) {
        try {
            float parsed = this.parseFloat(value);
            if (((FloatConfigOption)this.option).validateInput(parsed)) {
                ((FloatConfigOption)this.option).setValue(Float.valueOf(parsed));
                this.markValid();
            } else {
                this.markInvalid();
            }
        }
        catch (Exception e) {
            this.markInvalid();
        }
    }

    private float parseFloat(String value) throws ParseException {
        DecimalFormat format = new DecimalFormat("#");
        return format.parse(value).floatValue();
    }

    private static boolean isCharAllowed(char chr) {
        return Character.isDigit(chr) || ALLOWED_SPECIAL_CHARS.contains(Character.valueOf(chr));
    }
}

