/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.client.gui.widget.config;

import java.util.Objects;
import me.roundaround.stackables.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import me.roundaround.stackables.roundalib.config.option.IntConfigOption;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;

public final class RoundaLibIconButtons {
    private static final class_310 client = class_310.method_1551();
    public static final int SIZE_L = 18;
    public static final int SIZE_M = 13;
    public static final int SIZE_S = 9;
    public static final int ORIGIN_L = 0;
    public static final int ORIGIN_M = 36;
    public static final int ORIGIN_S = 62;
    public static final int INDEX_RESET = 0;
    public static final int INDEX_CANCEL = 1;
    public static final int INDEX_CONFIRM = 2;
    public static final int INDEX_HELP = 3;
    public static final int INDEX_CLOSE = 4;
    public static final int INDEX_UP = 5;
    public static final int INDEX_DOWN = 6;
    public static final int INDEX_LEFT = 7;
    public static final int INDEX_RIGHT = 8;
    public static final int INDEX_PLUS = 9;
    public static final int INDEX_MINUS = 10;

    public static IconButtonWidget resetButton(int x, int y, ConfigOption<?, ?> option) {
        return RoundaLibIconButtons.resetButton(x, y, option, 13);
    }

    public static IconButtonWidget resetButton(int x, int y, ConfigOption<?, ?> option, int size) {
        String modId = option.getConfig().getModId();
        IconButtonWidget button = RoundaLibIconButtons.resetButton(x, y, size, modId, buttonWidget -> option.resetToDefault());
        button.field_22763 = option.isModified() && !option.isDisabled();
        option.subscribeToValueChanges(Objects.requireNonNull(RoundaLibIconButtons.client.field_1755).hashCode(), (oldValue, newValue) -> {
            button.field_22763 = option.isModified() && !option.isDisabled();
        });
        return button;
    }

    public static IconButtonWidget resetButton(int x, int y, int size, String modId, PressAction onPress) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(0, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.reset.tooltip"))).build();
    }

    public static IconButtonWidget intStepButton(int x, int y, IntConfigOption option, boolean increment) {
        String modId = option.getConfig().getModId();
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        IconButtonWidget button = IconButtonWidget.builder(texture, buttonWidget -> {
            if (increment) {
                option.increment();
            } else {
                option.decrement();
            }
        }).size(9).position(x, y).autoCalculateUV(increment ? 9 : 10, 0, 62).tooltip((class_2561)class_2561.method_43469((String)(modId + ".roundalib." + (increment ? "step_up" : "step_down") + ".tooltip"), (Object[])new Object[]{option.getStep()})).build();
        button.field_22763 = !option.isDisabled() && (increment ? option.canIncrement() : option.canDecrement());
        option.subscribeToValueChanges(Objects.requireNonNull(RoundaLibIconButtons.client.field_1755).hashCode(), (oldValue, newValue) -> {
            button.field_22763 = !option.isDisabled() && (increment ? option.canIncrement() : option.canDecrement());
        });
        return button;
    }

    public static IconButtonWidget saveButton(int x, int y, String modId, PressAction onPress) {
        return RoundaLibIconButtons.saveButton(x, y, modId, onPress, 13);
    }

    public static IconButtonWidget saveButton(int x, int y, String modId, PressAction onPress, int size) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(2, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.save.tooltip"))).build();
    }

    public static IconButtonWidget discardButton(int x, int y, String modId, PressAction onPress) {
        return RoundaLibIconButtons.discardButton(x, y, modId, onPress, 13);
    }

    public static IconButtonWidget discardButton(int x, int y, String modId, PressAction onPress, int size) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(1, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.discard.tooltip"))).build();
    }

    public static IconButtonWidget upButton(int x, int y, String modId, PressAction onPress) {
        return RoundaLibIconButtons.upButton(x, y, modId, onPress, 13);
    }

    public static IconButtonWidget upButton(int x, int y, String modId, PressAction onPress, int size) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(5, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.up.tooltip"))).build();
    }

    public static IconButtonWidget downButton(int x, int y, String modId, PressAction onPress) {
        return RoundaLibIconButtons.downButton(x, y, modId, onPress, 13);
    }

    public static IconButtonWidget downButton(int x, int y, String modId, PressAction onPress, int size) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(6, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.down.tooltip"))).build();
    }

    public static IconButtonWidget leftButton(int x, int y, String modId, PressAction onPress) {
        return RoundaLibIconButtons.leftButton(x, y, modId, onPress, 13);
    }

    public static IconButtonWidget leftButton(int x, int y, String modId, PressAction onPress, int size) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(7, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.left.tooltip"))).build();
    }

    public static IconButtonWidget rightButton(int x, int y, String modId, PressAction onPress) {
        return RoundaLibIconButtons.rightButton(x, y, modId, onPress, 13);
    }

    public static IconButtonWidget rightButton(int x, int y, String modId, PressAction onPress, int size) {
        class_2960 texture = new class_2960(modId, "textures/roundalib.png");
        return IconButtonWidget.builder(texture, RoundaLibIconButtons.castPressAction(onPress)).size(size).position(x, y).autoCalculateUV(8, 0, RoundaLibIconButtons.getOriginForSize(size)).tooltip((class_2561)class_2561.method_43471((String)(modId + ".roundalib.right.tooltip"))).build();
    }

    private static int getOriginForSize(int size) {
        return switch (size) {
            case 18 -> 0;
            case 13 -> 36;
            case 9 -> 62;
            default -> throw new IllegalArgumentException("Invalid size: " + size);
        };
    }

    private static class_4185.class_4241 castPressAction(PressAction onPress) {
        return buttonWidget -> onPress.onPress((IconButtonWidget)buttonWidget);
    }

    @FunctionalInterface
    public static interface PressAction {
        public void onPress(IconButtonWidget var1);
    }
}

