/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.config;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import me.roundaround.stackables.roundalib.RoundaLib;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import me.roundaround.stackables.roundalib.shadow.nightconfig.core.CommentedConfig;
import me.roundaround.stackables.roundalib.shadow.nightconfig.core.Config;
import me.roundaround.stackables.roundalib.shadow.nightconfig.core.file.CommentedFileConfig;
import net.fabricmc.loader.api.FabricLoader;

public abstract class ModConfig {
    private final String modId;
    private final int configVersion;
    private final String configScreenI18nKey;
    private final boolean showGroupTitles;
    private final LinkedHashMap<String, LinkedList<ConfigOption<?, ?>>> configOptions = new LinkedHashMap();
    private int version;

    protected ModConfig(String modId) {
        this(modId, ModConfig.options(modId));
    }

    protected ModConfig(String modId, OptionsBuilder options) {
        this.modId = modId;
        this.configVersion = options.configVersion;
        this.configScreenI18nKey = options.configScreenI18nKey;
        this.showGroupTitles = options.showGroupTitles;
    }

    public void init() {
        this.loadFromFile();
        this.saveToFile();
    }

    public String getModId() {
        return this.modId;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public String getConfigScreenI18nKey() {
        return this.configScreenI18nKey;
    }

    public boolean getShowGroupTitles() {
        return this.showGroupTitles;
    }

    public LinkedHashMap<String, LinkedList<ConfigOption<?, ?>>> getConfigOptions() {
        return this.configOptions;
    }

    public void loadFromFile() {
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.getConfigFile()).preserveInsertionOrder().build();
        fileConfig.load();
        fileConfig.close();
        this.version = fileConfig.getIntOrElse("configVersion", -1);
        CommentedConfig config = CommentedConfig.copy(fileConfig);
        if (this.updateConfigVersion(this.version, config)) {
            fileConfig.putAll(config);
        }
        this.configOptions.entrySet().forEach(entry -> ((LinkedList)entry.getValue()).forEach(configOption -> {
            String key = (String)entry.getKey() + "." + configOption.getId();
            Object data = fileConfig.get(key);
            if (data != null) {
                configOption.deserialize(data);
            }
        }));
    }

    public void saveToFile() {
        if (this.version == this.configVersion && !this.isDirty()) {
            RoundaLib.LOGGER.info("Skipping saving config to file because nothing has changed.");
            return;
        }
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.getConfigFile()).preserveInsertionOrder().build();
        fileConfig.setComment("configVersion", " Config version is auto-generated\n DO NOT CHANGE");
        fileConfig.set("configVersion", (Object)this.configVersion);
        this.configOptions.entrySet().forEach(entry -> ((LinkedList)entry.getValue()).forEach(configOption -> {
            String key = (String)entry.getKey() + "." + configOption.getId();
            List<String> comment = configOption.getComment();
            if (!comment.isEmpty()) {
                fileConfig.setComment(key, " " + String.join((CharSequence)"\n ", comment));
            }
            fileConfig.set(key, configOption.serialize());
        }));
        fileConfig.save();
        fileConfig.close();
    }

    protected boolean updateConfigVersion(int version, Config config) {
        return false;
    }

    protected <T extends ConfigOption<?, ?>> T registerConfigOption(T configOption) {
        return this.registerConfigOption(null, configOption);
    }

    protected <T extends ConfigOption<?, ?>> T registerConfigOption(String group, T configOption) {
        Object key = this.modId;
        if (group != null) {
            key = (String)key + "." + group;
        }
        if (!this.configOptions.containsKey(key)) {
            this.configOptions.put((String)key, new LinkedList());
        }
        this.configOptions.get(key).add(configOption);
        return configOption;
    }

    private File getConfigDirectory() {
        File dir = FabricLoader.getInstance().getConfigDir().toFile();
        if (!dir.exists() && !dir.mkdirs()) {
            RoundaLib.LOGGER.warn("Failed to create config directory '{}'", (Object)dir.getAbsolutePath());
        }
        return dir;
    }

    private File getConfigFile() {
        return new File(this.getConfigDirectory(), this.modId + ".toml");
    }

    private boolean isDirty() {
        return this.configOptions.values().stream().anyMatch(group -> group.stream().anyMatch(ConfigOption::isDirty));
    }

    public static OptionsBuilder options(String modId) {
        return new OptionsBuilder(modId);
    }

    public static class OptionsBuilder {
        private int configVersion = 1;
        private String configScreenI18nKey;
        private boolean showGroupTitles;

        private OptionsBuilder(String modId) {
            this.configScreenI18nKey = modId + ".config.title";
            this.showGroupTitles = true;
        }

        public OptionsBuilder setConfigVersion(int configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public OptionsBuilder setConfigScreenI18nKey(String configScreenI18nKey) {
            this.configScreenI18nKey = configScreenI18nKey;
            return this;
        }

        public OptionsBuilder setShowGroupTitles(boolean showGroupTitles) {
            this.showGroupTitles = showGroupTitles;
            return this;
        }

        public OptionsBuilder hideGroupTitles() {
            return this.setShowGroupTitles(false);
        }
    }
}

