/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.config.option;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.roundaround.stackables.roundalib.config.ModConfig;
import me.roundaround.stackables.roundalib.config.option.ConfigOption;
import net.minecraft.class_2561;

public class FloatConfigOption
extends ConfigOption<Float, Builder> {
    private Optional<Float> minValue = Optional.empty();
    private Optional<Float> maxValue = Optional.empty();
    private List<Validator> validators = List.of();
    private boolean slider = false;
    private Optional<Integer> step = Optional.of(20);
    private Function<Float, String> valueDisplayFunction = value -> value.toString();

    protected FloatConfigOption(Builder builder) {
        super(builder);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        ArrayList<Validator> allValidators = new ArrayList<Validator>();
        if (this.minValue.isPresent()) {
            allValidators.add((prev, curr) -> curr >= this.minValue.get().floatValue());
        }
        if (this.maxValue.isPresent()) {
            allValidators.add((prev, curr) -> curr <= this.maxValue.get().floatValue());
        }
        if (!builder.customValidators.isEmpty()) {
            allValidators.addAll(builder.customValidators);
        }
        this.validators = List.copyOf(allValidators);
        this.slider = builder.slider;
        this.step = builder.step;
        this.valueDisplayFunction = builder.valueDisplayFunction;
    }

    private FloatConfigOption(FloatConfigOption other) {
        super(other);
        this.minValue = other.minValue;
        this.maxValue = other.maxValue;
        this.validators = other.validators;
        this.slider = other.slider;
        this.step = other.step;
        this.valueDisplayFunction = other.valueDisplayFunction;
    }

    @Override
    public void deserialize(Object data) {
        this.setValue(Float.valueOf(((Double)data).floatValue()));
    }

    public Optional<Float> getMinValue() {
        return this.minValue;
    }

    public Optional<Float> getMaxValue() {
        return this.maxValue;
    }

    public boolean validateInput(float newValue) {
        return this.validators.stream().allMatch(validator -> validator.apply(((Float)this.getValue()).floatValue(), newValue));
    }

    public boolean useSlider() {
        return this.slider;
    }

    public int getStep() {
        return this.step.isEmpty() ? 20 : this.step.get();
    }

    public String getValueAsString() {
        return this.getValueAsString(((Float)this.getValue()).floatValue());
    }

    public String getValueAsString(float value) {
        return this.valueDisplayFunction.apply((Float)this.getValue());
    }

    public FloatConfigOption copy() {
        return new FloatConfigOption(this);
    }

    public static Builder builder(ModConfig config, String id, String labelI18nKey) {
        return new Builder(config, id, labelI18nKey);
    }

    public static Builder builder(ModConfig config, String id, class_2561 label) {
        return new Builder(config, id, label);
    }

    public static Builder sliderBuilder(ModConfig config, String id, String labelI18nKey) {
        return FloatConfigOption.builder(config, id, labelI18nKey).setUseSlider(true);
    }

    public static Builder sliderBuilder(ModConfig config, String id, class_2561 label) {
        return FloatConfigOption.builder(config, id, label).setUseSlider(true);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<Float, Builder> {
        private Optional<Float> minValue = Optional.empty();
        private Optional<Float> maxValue = Optional.empty();
        private List<Validator> customValidators = new ArrayList<Validator>();
        private boolean slider = false;
        private Optional<Integer> step = Optional.of(20);
        private Function<Float, String> valueDisplayFunction = value -> String.format("%.2f", value);

        private Builder(ModConfig config, String id, String labelI18nKey) {
            super(config, id, labelI18nKey, Float.valueOf(0.0f));
        }

        private Builder(ModConfig config, String id, class_2561 label) {
            super(config, id, label, Float.valueOf(0.0f));
        }

        public Builder setDefaultValue(float defaultValue) {
            this.defaultValue = Float.valueOf(defaultValue);
            return this;
        }

        public Builder setMinValue(float minValue) {
            this.minValue = Optional.of(Float.valueOf(minValue));
            return this;
        }

        public Builder setMaxValue(float maxValue) {
            this.maxValue = Optional.of(Float.valueOf(maxValue));
            return this;
        }

        public Builder addCustomValidator(Validator validator) {
            this.customValidators.add(validator);
            return this;
        }

        public Builder setUseSlider(boolean slider) {
            this.slider = slider;
            return this;
        }

        public Builder setStep(int step) {
            this.step = Optional.of(step);
            return this;
        }

        public Builder setValueDisplayFunction(Function<Float, String> valueDisplayFunction) {
            this.valueDisplayFunction = valueDisplayFunction;
            return this;
        }

        public FloatConfigOption build() {
            return new FloatConfigOption(this);
        }
    }

    @FunctionalInterface
    public static interface Validator {
        public boolean apply(float var1, float var2);
    }
}

