/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.stackables.roundalib.config.value;

import java.util.Arrays;
import me.roundaround.stackables.roundalib.config.ModConfig;
import me.roundaround.stackables.roundalib.config.value.ListOptionValue;

public enum GuiTheme implements ListOptionValue<GuiTheme>
{
    LIGHT("light"),
    DARK("dark"),
    AUTO("auto");

    private final String id;

    private GuiTheme(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getI18nKey(ModConfig config) {
        return config.getModId() + ".roundalib.gui_theme." + this.id;
    }

    @Override
    public GuiTheme getFromId(String id) {
        return GuiTheme.fromId(id);
    }

    @Override
    public GuiTheme getNext() {
        return GuiTheme.values()[(this.ordinal() + 1) % GuiTheme.values().length];
    }

    @Override
    public GuiTheme getPrev() {
        return GuiTheme.values()[(this.ordinal() + GuiTheme.values().length - 1) % GuiTheme.values().length];
    }

    public static GuiTheme getDefault() {
        return AUTO;
    }

    public static GuiTheme fromId(String id) {
        return Arrays.stream(GuiTheme.values()).filter(guiAlignment -> guiAlignment.id.equals(id)).findFirst().orElse(GuiTheme.getDefault());
    }
}

