/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBarScreenAddon
extends BasicScreenAddon {
    private final IEnergyStorage handler;
    private IAsset background;

    public EnergyBarScreenAddon(int posX, int posY, IEnergyStorage handler) {
        super(posX, posY);
        this.handler = handler;
    }

    public static IAsset drawBackground(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY) {
        IAsset background = IAssetProvider.getAsset(provider, AssetTypes.ENERGY_BACKGROUND);
        Point offset = background.getOffset();
        Rectangle area = background.getArea();
        AssetUtil.drawAsset(guiGraphics, screen, background, guiX + handlerPosX + offset.x, guiY + handlerPosY + offset.y);
        return background;
    }

    public static void drawForeground(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int handlerPosX, int handlerPosY, int guiX, int guiY, double stored, double capacity) {
        IAsset asset = IAssetProvider.getAsset(provider, AssetTypes.ENERGY_BAR);
        Point offset = asset.getOffset();
        Rectangle area = asset.getArea();
        int powerOffset = (int)(stored / Math.max(capacity, 1.0) * (double)area.height);
        guiGraphics.m_280218_(asset.getResourceLocation(), handlerPosX + offset.x, handlerPosY + offset.y + area.height - powerOffset, area.x, area.y + (area.height - powerOffset), area.width, powerOffset);
    }

    public static List<Component> getTooltip(int stored, int capacity) {
        return Arrays.asList(Component.m_237113_((String)(ChatFormatting.GOLD + "Power:")), Component.m_237113_((String)(new DecimalFormat().format(stored) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(capacity) + ChatFormatting.DARK_AQUA + " FE")));
    }

    @Override
    public int getXSize() {
        return this.background != null ? this.background.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.background != null ? this.background.getArea().height : 0;
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.background = EnergyBarScreenAddon.drawBackground(guiGraphics, screen, provider, this.getPosX(), this.getPosY(), guiX, guiY);
    }

    @Override
    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        EnergyBarScreenAddon.drawForeground(guiGraphics, screen, provider, this.getPosX(), this.getPosY(), guiX, guiY, this.handler.getEnergyStored(), this.handler.getMaxEnergyStored());
    }

    @Override
    public List<Component> getTooltipLines() {
        return EnergyBarScreenAddon.getTooltip(this.handler.getEnergyStored(), this.handler.getMaxEnergyStored());
    }
}

