/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.filter;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterAction;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.client.screen.addon.ItemstackFilterScreenAddon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackFilter
implements IFilter<ItemStack> {
    private static FilterAction<ItemStack> SIMPLE = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)itemStackFilterSlot.getFilter()))));
    private static FilterAction<ItemStack> IGNORE_DURABILITY = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> stack.equals((ItemStack)itemStackFilterSlot.getFilter(), false)));
    private static FilterAction<ItemStack> DURABILITY_LESS_50 = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)itemStackFilterSlot.getFilter()))) && stack.m_41773_() < stack.m_41776_() / 50);
    private static FilterAction<ItemStack> DAMAGED = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)itemStackFilterSlot.getFilter()))) && stack.m_41773_() < stack.m_41776_());
    private static FilterAction<ItemStack> NOT_DAMAGED = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)itemStackFilterSlot.getFilter()))) && stack.m_41773_() == stack.m_41776_());
    private static FilterAction<ItemStack> DURABILITY_MORE_50 = new FilterAction<ItemStack>((itemStackIFilter, stack) -> Arrays.stream(itemStackIFilter.getFilterSlots()).anyMatch(itemStackFilterSlot -> ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)itemStackFilterSlot.getFilter()))) && stack.m_41773_() > stack.m_41776_() / 50);
    private static FilterAction<ItemStack>[] ACTIONS = new FilterAction[]{SIMPLE, IGNORE_DURABILITY, DURABILITY_LESS_50, DAMAGED, NOT_DAMAGED, DURABILITY_MORE_50};
    private final FilterSlot<ItemStack>[] filter;
    private IFilter.Type type;
    private int pointer;
    private String name;

    public ItemStackFilter(String name, int filterSize) {
        this.name = name;
        this.filter = new FilterSlot[filterSize];
        this.type = IFilter.Type.WHITELIST;
        this.pointer = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean acceptsAsFilter(ItemStack filter) {
        return true;
    }

    @Override
    public void setFilter(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot].setFilter(stack);
        this.onContentChanged();
    }

    @Override
    public void setFilter(int slot, FilterSlot<ItemStack> filterSlot) {
        if (slot < 0 || slot >= this.filter.length) {
            throw new RuntimeException("Filter slot " + slot + " not in valid range - [0," + this.filter.length + ")");
        }
        this.filter[slot] = filterSlot;
    }

    @Override
    public FilterSlot<ItemStack>[] getFilterSlots() {
        return this.filter;
    }

    @Override
    public IFilter.Type getType() {
        return this.type;
    }

    @Override
    public void toggleFilterMode() {
        this.type = this.type.equals((Object)IFilter.Type.WHITELIST) ? IFilter.Type.BLACKLIST : IFilter.Type.WHITELIST;
    }

    @Override
    public void selectNextFilter() {
        this.pointer = (this.pointer + 1) % ACTIONS.length;
    }

    @Override
    public FilterAction<ItemStack> getAction() {
        return ACTIONS[this.pointer];
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("Pointer", this.pointer);
        CompoundTag filter = new CompoundTag();
        for (FilterSlot<ItemStack> itemStackFilterSlot : this.filter) {
            if (itemStackFilterSlot == null || itemStackFilterSlot.getFilter().m_41619_()) continue;
            filter.m_128365_("" + itemStackFilterSlot.getFilterID(), (Tag)itemStackFilterSlot.getFilter().serializeNBT());
        }
        compoundNBT.m_128365_("Filter", (Tag)filter);
        compoundNBT.m_128359_("Type", this.type.name());
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.pointer = nbt.m_128451_("Pointer");
        CompoundTag filter = nbt.m_128469_("Filter");
        for (FilterSlot<ItemStack> filterSlot : this.filter) {
            filterSlot.setFilter(ItemStack.f_41583_);
        }
        for (String key : filter.m_128431_()) {
            this.filter[Integer.parseInt(key)].setFilter(ItemStack.m_41712_((CompoundTag)filter.m_128469_(key)));
        }
        this.type = IFilter.Type.valueOf(nbt.m_128461_("Type"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        list.add(() -> new ItemstackFilterScreenAddon(this));
        return list;
    }

    public void onContentChanged() {
    }
}

