/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements PehkuiEntityExtensions {
    @Shadow
    boolean f_19861_;
    @Shadow
    boolean f_19803_;
    private boolean pehkui_shouldSyncScales = false;
    private boolean pehkui_shouldIgnoreScaleNbt = false;
    private ScaleData[] pehkui_scaleCache = null;

    @Override
    public ScaleData pehkui_constructScaleData(ScaleType type) {
        return ScaleData.Builder.create().type(type).entity((Entity)this).build();
    }

    @Override
    public ScaleData[] pehkui_getScaleCache() {
        return this.pehkui_scaleCache;
    }

    @Override
    public void pehkui_setScaleCache(ScaleData[] scaleCache) {
        this.pehkui_scaleCache = scaleCache;
    }

    @Override
    public void pehkui_setShouldSyncScales(boolean sync) {
        this.pehkui_shouldSyncScales = sync;
    }

    @Override
    public boolean pehkui_shouldSyncScales() {
        return this.pehkui_shouldSyncScales;
    }

    @Override
    public boolean pehkui_shouldIgnoreScaleNbt() {
        return this.pehkui_shouldIgnoreScaleNbt;
    }

    @Override
    public void pehkui_setShouldIgnoreScaleNbt(boolean ignore) {
        this.pehkui_shouldIgnoreScaleNbt = ignore;
    }

    @Inject(at={@At(value="HEAD")}, method={"readNbt"})
    private void pehkui$readNbt(CompoundTag tag, CallbackInfo info) {
        this.pehkui_readScaleNbt(tag);
    }

    @Override
    public void pehkui_readScaleNbt(CompoundTag nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return;
        }
        if (nbt.m_128425_("pehkui:scale_data_types", 10) && !DebugCommand.unmarkEntityForScaleReset((Entity)this, nbt)) {
            CompoundTag typeData = nbt.m_128469_("pehkui:scale_data_types");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                String key = ((ResourceLocation)entry.getKey()).toString();
                if (!typeData.m_128425_(key, 10)) continue;
                ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
                scaleData.readNbt(typeData.m_128469_(key));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"writeNbt"})
    private void pehkui$writeNbt(CompoundTag tag, CallbackInfoReturnable<CompoundTag> info) {
        this.pehkui_writeScaleNbt(tag);
    }

    @Override
    public CompoundTag pehkui_writeScaleNbt(CompoundTag nbt) {
        if (this.pehkui_shouldIgnoreScaleNbt()) {
            return nbt;
        }
        CompoundTag typeData = new CompoundTag();
        for (ScaleData scaleData : this.pehkui_getScales().values()) {
            CompoundTag compound;
            if (scaleData == null || (compound = scaleData.writeNbt(new CompoundTag())).m_128440_() == 0) continue;
            typeData.m_128365_(ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, scaleData.getScaleType()).toString(), (Tag)compound);
        }
        if (typeData.m_128440_() > 0) {
            nbt.m_128365_("pehkui:scale_data_types", (Tag)typeData);
        }
        return nbt;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void pehkui$tick(CallbackInfo info) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleUtils.tickScale(this.pehkui_getScaleData(type));
        }
    }

    @ModifyReturnValue(method={"getDimensions"}, at={@At(value="RETURN")})
    private EntityDimensions pehkui$getDimensions(EntityDimensions original) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)this);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            return original.m_20390_(widthScale, heightScale);
        }
        return original;
    }

    @Inject(at={@At(value="HEAD")}, method={"onStartedTrackingBy"})
    private void pehkui$onStartedTrackingBy(ServerPlayer player, CallbackInfo info) {
        ScaleUtils.syncScalesOnTrackingStart((Entity)this, player.f_8906_);
    }

    @ModifyVariable(method={"dropStack(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="STORE"))
    private ItemEntity pehkui$dropStack(ItemEntity entity) {
        ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
        return entity;
    }

    @ModifyExpressionValue(method={"move"}, at={@At(value="CONSTANT", args={"doubleValue=1.0E-7D"})})
    private double pehkui$move$minVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale < 1.0f ? (double)(scale * scale) * value : value;
    }

    @ModifyArg(method={"move"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;adjustMovementForSneaking(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/MovementType;)Lnet/minecraft/util/math/Vec3d;"))
    private Vec3 pehkui$move$adjustMovementForSneaking(Vec3 movement, MoverType type) {
        if (type == MoverType.SELF || type == MoverType.PLAYER) {
            return movement.m_82490_((double)ScaleUtils.getMotionScale((Entity)this));
        }
        return movement;
    }

    @WrapOperation(method={"pushAwayFrom"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V")})
    private void pehkui$pushSelfAwayFrom$other(Entity obj, double x, double y, double z, Operation<Void> original, @Local(argsOnly=true) Entity other) {
        float otherScale = ScaleUtils.getMotionScale(other);
        if (otherScale != 1.0f) {
            x *= (double)otherScale;
            z *= (double)otherScale;
        }
        original.call(new Object[]{obj, x, y, z});
    }

    @WrapOperation(method={"pushAwayFrom"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V")})
    private void pehkui$pushSelfAwayFrom$self(Entity obj, double x, double y, double z, Operation<Void> original) {
        float ownScale = ScaleUtils.getMotionScale((Entity)this);
        if (ownScale != 1.0f) {
            x *= (double)ownScale;
            z *= (double)ownScale;
        }
        original.call(new Object[]{obj, x, y, z});
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnSprintingParticles"}, cancellable=true)
    private void pehkui$spawnSprintingParticles(CallbackInfo info) {
        if (ScaleUtils.getMotionScale((Entity)this) < 1.0f) {
            info.cancel();
        }
    }

    @Override
    public boolean pehkui_isFirstUpdate() {
        return this.f_19803_;
    }

    @Override
    public boolean pehkui_getOnGround() {
        return this.f_19861_;
    }

    @Override
    public void pehkui_setOnGround(boolean onGround) {
        this.f_19861_ = onGround;
    }
}

