/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.McJtyLib;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PacketSendServerCommand(String modid, String command, TypedMap arguments) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "sendservercommand");

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.modid);
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.arguments);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public static PacketSendServerCommand create(String modid, String command, TypedMap arguments) {
        return new PacketSendServerCommand(modid, command, arguments);
    }

    public static PacketSendServerCommand create(FriendlyByteBuf buf) {
        String modid = buf.m_130136_(Short.MAX_VALUE);
        String command = buf.m_130136_(Short.MAX_VALUE);
        TypedMap arguments = TypedMapTools.readArguments(buf);
        return new PacketSendServerCommand(modid, command, arguments);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            try {
                boolean result = McJtyLib.handleCommand(this.modid, this.command, player, this.arguments);
                if (!result) {
                    Logging.logError("Error handling command '" + this.command + "' for mod '" + this.modid + "'!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }));
    }
}

