/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.typed;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class Type<V> {
    public static final Type<Integer> INTEGER = Type.create(Integer.class, (v, buf) -> buf.writeInt(v.intValue()), FriendlyByteBuf::readInt);
    public static final Type<Float> FLOAT = Type.create(Float.class, (v, buf) -> buf.writeFloat(v.floatValue()), FriendlyByteBuf::readFloat);
    public static final Type<Double> DOUBLE = Type.create(Double.class, (v, buf) -> buf.writeDouble(v.doubleValue()), FriendlyByteBuf::readDouble);
    public static final Type<Long> LONG = Type.create(Long.class, (v, buf) -> buf.writeLong(v.longValue()), FriendlyByteBuf::readLong);
    public static final Type<String> STRING = Type.create(String.class, (v, buf) -> NetworkTools.writeStringUTF8(buf, v), NetworkTools::readStringUTF8);
    public static final Type<UUID> UUID = Type.create(UUID.class, (v, buf) -> {
        if (v != null) {
            buf.writeBoolean(true);
            buf.m_130077_(v);
        } else {
            buf.writeBoolean(false);
        }
    }, buf -> {
        if (buf.readBoolean()) {
            return buf.m_130259_();
        }
        return null;
    });
    public static final Type<Boolean> BOOLEAN = Type.create(Boolean.class, (v, buf) -> buf.writeBoolean(v.booleanValue()), FriendlyByteBuf::readBoolean);
    public static final Type<BlockPos> BLOCKPOS = Type.create(BlockPos.class, (v, buf) -> {
        if (v != null) {
            buf.writeBoolean(true);
            buf.m_130064_(v);
        } else {
            buf.writeBoolean(false);
        }
    }, buf -> {
        if (buf.readBoolean()) {
            return buf.m_130135_();
        }
        return null;
    });
    public static final Type<ItemStack> ITEMSTACK = Type.create(ItemStack.class, (v, buf) -> buf.m_130055_(v), FriendlyByteBuf::m_130267_);
    public static final Type<ResourceKey<Level>> DIMENSION_TYPE = Type.create(ResourceKey.class, (v, buf) -> buf.m_130085_(v.m_135782_()), buf -> LevelTools.getId(buf.m_130281_()));
    public static final Type<List<String>> STRING_LIST = Type.create(List.class, (v, buf) -> NetworkTools.writeStringList(buf, v), NetworkTools::readStringList);
    public static final Type<List<ItemStack>> ITEMSTACK_LIST = Type.create(List.class, (v, buf) -> NetworkTools.writeItemStackList(buf, v), NetworkTools::readItemStackList);
    public static final Type<List<BlockPos>> POS_LIST = Type.create(List.class, (v, buf) -> NetworkTools.writeBlockPosList(buf, v), NetworkTools::readBlockPosList);
    @Nonnull
    private final Class<V> type;
    @Nullable
    private final BiConsumer<V, FriendlyByteBuf> serializer;
    @Nullable
    private final Function<FriendlyByteBuf, V> deserializer;

    private Type(@Nonnull Class<V> type, @Nullable BiConsumer<V, FriendlyByteBuf> serializer, @Nullable Function<FriendlyByteBuf, V> deserializer) {
        this.type = type;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Nonnull
    public static <V> Type<V> create(@Nonnull Class<? super V> type, BiConsumer<V, FriendlyByteBuf> serializer, Function<FriendlyByteBuf, V> deserializer) {
        return new Type<V>(type, serializer, deserializer);
    }

    @Nonnull
    public static <V> Type<V> create(@Nonnull Class<? super V> type) {
        return new Type<V>(type, null, null);
    }

    @Nonnull
    public Class<V> getType() {
        return this.type;
    }

    public void serialize(FriendlyByteBuf buf, Object value) {
        this.serializer.accept(value, buf);
    }

    public <T extends GenericTileEntity> void deserialize(FriendlyByteBuf buf, ValueHolder<T, V> value, T te) {
        V v = this.deserializer.apply(buf);
        value.setter().accept(te, v);
    }

    @Nullable
    public BiConsumer<V, FriendlyByteBuf> getSerializer() {
        return this.serializer;
    }

    @Nullable
    public Function<FriendlyByteBuf, V> getDeserializer() {
        return this.deserializer;
    }

    public boolean isA(Object b) {
        return this.type.isInstance(b);
    }

    @Nonnull
    public List<V> convert(@Nonnull List<?> list) {
        for (Object o : list) {
            if (o == null || this.type.isInstance(o)) continue;
            throw new ClassCastException("Cannot cast List<? super " + o.getClass().getName() + "> to List<" + this.type.getName() + ">");
        }
        return list;
    }

    public V convert(Object o) {
        return this.type.cast(o);
    }

    public String toString() {
        return "Type(" + this.getType().getSimpleName() + ")";
    }
}

